/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.util;

import com.podloot.eyemod.lib.gui.EyeLib;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class Pos {
    String name = "undefined";
    BlockPos pos;
    ResourceLocation world;

    public Pos() {
    }

    public Pos(BlockPos pos, ResourceLocation world) {
        this.pos = pos;
        this.world = world;
    }

    public Pos(BlockPos pos, ResourceLocation world, String name) {
        this(pos, world);
        this.name = name;
    }

    public Pos fromString(String nbt) {
        String[] i;
        if (nbt.contains("|") && (i = nbt.split("\\|")).length >= 4) {
            BlockPos pos = new BlockPos(EyeLib.getInt(i[0]), EyeLib.getInt(i[1]), EyeLib.getInt(i[2]));
            ResourceLocation dim = new ResourceLocation(i[3]);
            this.pos = pos;
            this.world = dim;
            if (i.length == 5) {
                this.name = i[4];
            }
            return this;
        }
        return null;
    }

    public String toNbt() {
        return this.getPos().m_123341_() + "|" + this.getPos().m_123342_() + "|" + this.getPos().m_123343_() + "|" + this.getWorld().toString() + (String)(this.name.equals("undefined") ? "" : "|" + this.name);
    }

    public ResourceLocation getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getName() {
        return this.name;
    }

    public String asString() {
        return this.asString(true);
    }

    public String asString(boolean w) {
        if (this.pos == null) {
            return "Undefined";
        }
        return (String)(this.name.equals("undefined") ? "" : this.name + ": ") + this.pos.m_123341_() + "/" + this.pos.m_123342_() + "/" + this.pos.m_123343_() + (String)(this.world == null || !w ? "" : " (" + this.world.m_135815_() + ")");
    }
}

