/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.panels;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.widgets.EyeScrollBar;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class EyeScrollPanel
extends EyePanel {
    public EyeWidget.Axis axis = EyeWidget.Axis.VERTICAL;
    protected int scroll_x = 0;
    protected int scroll_y = 0;
    public EyeScrollBar scroll_h = null;
    public EyeScrollBar scroll_v = null;

    public EyeScrollPanel(int width, int height) {
        super(width, height);
    }

    public void setScrollBar(EyeWidget.Axis a, EyeScrollBar bar) {
        bar.setBar(this);
        this.axis = a;
        if (a == EyeWidget.Axis.HORIZONTAL) {
            this.scroll_h = bar;
        } else {
            this.scroll_v = bar;
        }
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        GL11.glEnable((int)3089);
        int s = (int)Minecraft.m_91087_().m_91268_().m_85449_();
        GL11.glScissor((int)(x * s), (int)(Minecraft.m_91087_().m_91268_().m_85442_() - (y + this.getHeight()) * s), (int)(this.getWidth() * s), (int)(this.getHeight() * s));
        super.draw(matrices, x, y);
        GL11.glDisable((int)3089);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        this.setScroll(EyeWidget.Axis.VERTICAL, this.getScroll_y() - (int)amount * 6);
        return true;
    }

    public void setScroll(EyeWidget.Axis axis, int a) {
        int la;
        int lim;
        if (axis == EyeWidget.Axis.HORIZONTAL) {
            lim = this.getScrollWidth() - this.getWidth();
            if (lim < 0) {
                return;
            }
            this.scroll_x = la = a == -999 ? lim : (a <= 0 ? 0 : (a >= lim ? lim : a));
            if (this.scroll_h != null) {
                this.scroll_h.setValue(la);
            }
        }
        if (axis == EyeWidget.Axis.VERTICAL) {
            lim = this.getScrollHeight() - this.getHeight();
            if (lim < 0) {
                return;
            }
            this.scroll_y = la = a == -999 ? lim : (a <= 0 ? 0 : (a >= lim ? lim : a));
            if (this.scroll_v != null) {
                this.scroll_v.setValue(la);
            }
        }
        this.updateScroll();
    }

    public void updateScroll() {
        for (EyeWidget e : this.widgets) {
            if (e instanceof EyeScrollBar) continue;
            e.setOff(-this.getScroll_x(), -this.getScroll_y());
        }
    }

    public int getScrollWidth() {
        int w = 0;
        for (EyeWidget e : this.widgets) {
            if (e instanceof EyeScrollBar) continue;
            int nw = e.getX() - e.getOffX() + e.getWidth();
            w = nw > w ? nw : w;
        }
        return w;
    }

    public int getScrollHeight() {
        int h = 0;
        for (EyeWidget e : this.widgets) {
            if (e instanceof EyeScrollBar) continue;
            int nh = e.getY() - e.getOffY() + e.getHeight();
            h = nh > h ? nh : h;
        }
        return h;
    }

    public int getScroll_x() {
        return this.scroll_x;
    }

    public int getScroll_y() {
        return this.scroll_y;
    }
}

