/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.panels;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.ArrayList;
import java.util.List;

public class EyePanel
extends EyeWidget {
    protected List<EyeWidget> widgets = new ArrayList<EyeWidget>();

    public EyePanel(int width, int height) {
        super(true, width, height);
    }

    public void add(EyeWidget e, int x, int y) {
        e.setPos(x, y);
        e.setParent(this);
        this.widgets.add(e);
    }

    public void replace(int i, EyeWidget e) {
        if (this.widgets.size() > i) {
            e.setParent(this);
            e.setPos(this.widgets.get(i).getX(), this.widgets.get(i).getY());
            this.widgets.set(i, e);
        }
    }

    public void remove(EyeWidget e) {
        e.close();
        this.widgets.remove(e);
    }

    public void remove(int i) {
        if (this.widgets.size() > i && i >= 0) {
            this.widgets.get(i).close();
            this.widgets.remove(i);
        }
    }

    public boolean has(EyeWidget e) {
        return this.widgets.contains(e);
    }

    public int size() {
        return this.widgets.size();
    }

    public EyeWidget get(int i) {
        if (this.widgets.size() > i) {
            return this.widgets.get(i);
        }
        return null;
    }

    public void clear() {
        this.widgets.clear();
    }

    @Override
    public void close() {
        for (EyeWidget e : this.widgets) {
            e.close();
        }
    }

    public List<EyeWidget> getWidgets() {
        return this.widgets;
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        if (this.isHidden()) {
            return;
        }
        super.draw(matrices, x, y);
        for (EyeWidget e : this.widgets) {
            if (e.isHidden()) continue;
            e.draw(matrices, x + e.getX(), y + e.getY());
        }
    }

    @Override
    public void drawHover(PoseStack matrices, int mouseX, int mouseY) {
        EyeWidget w = this.getOn(mouseX, mouseY);
        if (w != null) {
            w.drawHover(matrices, mouseX, mouseY);
        }
    }

    @Override
    public void tick(int mx, int my) {
        for (EyeWidget e : this.widgets) {
            e.tick(mx, my);
        }
    }

    @Override
    public EyeWidget getHit(int x, int y) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            EyeWidget w = this.widgets.get(i);
            if (!w.inBounds(x, y) || w.isHidden() || !w.isClickable()) continue;
            return w;
        }
        return null;
    }

    public EyeWidget getOn(int x, int y) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            EyeWidget w = this.widgets.get(i);
            if (!w.inBounds(x, y) || w.isHidden()) continue;
            if (!(w instanceof EyePanel)) {
                if (w.getHover() == null) continue;
                return w;
            }
            return ((EyePanel)w).getOn(x, y);
        }
        return null;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.clearFocus();
        EyeWidget w = this.getHit((int)mouseX, (int)mouseY);
        if (w != null) {
            w.setFocussed(true);
            w.mouseClicked(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            EyeWidget w = this.widgets.get(i);
            if (!w.inBounds((int)mouseX, (int)mouseY) || !w.mouseScrolled(mouseX, mouseY, amount)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EyeWidget getFocussed() {
        if (this.isFocussed()) {
            return this;
        }
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            EyeWidget foc = this.widgets.get(i).getFocussed();
            if (foc == null) continue;
            return foc;
        }
        return null;
    }

    @Override
    public void clearFocus() {
        this.setFocussed(false);
        for (EyeWidget w : this.widgets) {
            w.clearFocus();
        }
    }
}

