/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.panels;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;

public class EyeBoxPanel
extends EyePanel {
    EyeWidget.Axis axis;
    int space = 0;

    public EyeBoxPanel(int width, int height, EyeWidget.Axis axis) {
        this(width, height, axis, 4);
    }

    public EyeBoxPanel(int width, int height, EyeWidget.Axis axis, int space) {
        super(width, height);
        this.axis = axis;
        this.space = space;
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        super.draw(matrices, x, y);
    }

    public void add(int i, EyeWidget e) {
        boolean a = this.axis == EyeWidget.Axis.HORIZONTAL;
        e.setSize(a ? e.getWidth() : this.getWidth(), a ? this.getHeight() : e.getHeight());
        e.setParent(this);
        if (i < 0 || i >= this.widgets.size()) {
            this.widgets.add(e);
        } else {
            this.widgets.add(i, e);
        }
        this.setItems();
    }

    public boolean delete(int i) {
        if (i >= 0 && i < this.widgets.size()) {
            this.widgets.remove(i);
            return true;
        }
        this.widgets.remove(this.widgets.size() - 1);
        return false;
    }

    public boolean delete(EyeWidget e) {
        return this.widgets.remove(e);
    }

    @Override
    public EyeWidget get(int i) {
        if (i >= 0 && i < this.widgets.size()) {
            return (EyeWidget)this.widgets.get(i);
        }
        return null;
    }

    @Override
    public boolean has(EyeWidget e) {
        return this.widgets.contains(e);
    }

    public void setItems() {
        boolean a = this.axis == EyeWidget.Axis.HORIZONTAL;
        int range = 0;
        for (int i = 0; i < this.widgets.size(); ++i) {
            EyeWidget w = (EyeWidget)this.widgets.get(i);
            w.setPos(a ? range : 0, a ? 0 : range);
            range += (a ? w.getWidth() : w.getHeight()) + this.space;
        }
        this.setWidth(a ? range - this.space : this.getWidth());
        this.setHeight(a ? this.getHeight() : range - this.space);
    }

    public void setSpace(int s) {
        this.space = s;
        this.setItems();
    }
}

