/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class EyeScreen
extends Screen {
    public EyePanel base;
    int hover_wait;
    int hover_time;
    int last_x;
    int last_y;

    public EyeScreen(String title, int width, int height) {
        super((Component)new Line(title).asText());
        this.hover_time = this.hover_wait = 40;
        this.base = new EyePanel(width, height);
        this.setBase();
    }

    public abstract void paint(PoseStack var1);

    public abstract void update(int var1, int var2);

    public void setBase() {
        if (this.base == null) {
            return;
        }
        int w = Minecraft.m_91087_().m_91268_().m_85445_();
        int h = Minecraft.m_91087_().m_91268_().m_85446_();
        this.base.setPos((w - this.base.getWidth()) / 2, (h - this.base.getHeight()) / 2);
    }

    public void m_6574_(Minecraft client, int width, int height) {
        this.setBase();
        super.m_6574_(client, width, height);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.paint(matrices);
        if (this.base != null) {
            this.base.tick(mouseX, mouseY);
            this.base.draw(matrices, this.base.getX(), this.base.getY());
            if (this.hover_time < 0) {
                this.base.drawHover(matrices, mouseX, mouseY);
            }
        }
        this.update(mouseX, mouseY);
        if (this.hover_time >= -1) {
            --this.hover_time;
        }
    }

    public EyeWidget getFocussed() {
        return this.base.getFocussed();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.base.close();
        super.m_7379_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.getFocussed() != null) {
            this.getFocussed().keyPressed(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.getFocussed() != null) {
            this.getFocussed().keyReleased(keyCode, scanCode, modifiers);
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (this.getFocussed() != null) {
            this.getFocussed().charTyped(chr, modifiers);
        }
        return super.m_5534_(chr, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.base.mouseClicked(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.getFocussed() != null) {
            return this.getFocussed().mouseReleased(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.hover_time = this.hover_wait;
        this.base.mouseMoved(mouseX, mouseY);
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.getFocussed() != null) {
            return this.getFocussed().mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return this.base.mouseScrolled(mouseX, mouseY, amount);
    }
}

