/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.items;

import com.podloot.eyemod.Eye;
import com.podloot.eyemod.blocks.Charger;
import com.podloot.eyemod.blocks.Router;
import com.podloot.eyemod.blocks.entities.RouterEntity;
import com.podloot.eyemod.config.EyeConfig;
import com.podloot.eyemod.config.EyeConfigData;
import com.podloot.eyemod.events.EyeDeviceEvent;
import com.podloot.eyemod.events.EyeEvents;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.gui.util.Timer;
import com.podloot.eyemod.gui.util.messages.EyeMsgHandler;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Pos;
import com.podloot.eyemod.network.ClientGuiOpen;
import com.podloot.eyemod.network.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;

public class ItemDevice
extends Item {
    public List<Timer> timers = new ArrayList<Timer>();
    int storage = 256;
    int battery = 256;

    public ItemDevice(Item.Properties p, int storage, int battery) {
        super(p);
        this.storage = storage;
        this.battery = battery;
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag p_41424_) {
        String name = "No Owner";
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("user")) {
            name = itemStack.m_41783_().m_128461_("user");
        }
        tooltip.add((Component)Component.m_237113_((String)name).m_130940_(ChatFormatting.DARK_GRAY));
        super.m_7373_(itemStack, world, tooltip, p_41424_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        CompoundTag data = user.m_21120_(hand).m_41783_();
        if (!data.m_128441_("user")) {
            user.m_21120_(hand).m_41751_(this.getDefaultNbt(data, world, user));
        }
        if (user.m_21120_(hand).m_41773_() < user.m_21120_(hand).m_41776_()) {
            if (!world.f_46443_) {
                EyeConfigData config = new EyeConfigData();
                MinecraftForge.EVENT_BUS.post((Event)new EyeDeviceEvent(EyeEvents.EventSide.BOTH, user, user.m_21120_(hand), EyeEvents.DeviceAction.Open));
                PacketHandler.INSTANCE.send(PacketDistributor.DIMENSION.with(() -> world.m_46472_()), (Object)new ClientGuiOpen(user.m_6302_(), hand, config, (Boolean)EyeConfig.op_apps.get(), this.isOP(world, user)));
                return InteractionResultHolder.m_19090_((Object)user.m_21120_(hand));
            }
        } else {
            if (world.m_5776_()) {
                this.sendMsg("text.eyemod.battery_empty");
            }
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
    }

    private CompoundTag getDefaultNbt(CompoundTag data, Level world, Player user) {
        data.m_128359_("user", user.m_6302_());
        if (!data.m_128441_("apps")) {
            ListTag list = data.m_128437_("apps", (int)Naming.Type.STRING.type);
            list.add((Object)StringTag.m_129297_((String)"eyemod:settings"));
            list.add((Object)StringTag.m_129297_((String)"eyemod:store"));
            list.add((Object)StringTag.m_129297_((String)"eyemod:mail"));
            data.m_128365_("apps", (Tag)list);
        }
        data.m_128359_("ID", this.getUniqueID(world));
        data.m_128405_("storage", this.storage);
        CompoundTag set = new CompoundTag();
        set.m_128405_("device", -14540254);
        set.m_128405_("background", -13092808);
        set.m_128379_("location", true);
        set.m_128379_("notification", true);
        data.m_128365_("settings", (Tag)set);
        return data;
    }

    private boolean isOP(Level world, Player user) {
        boolean opConfig = ((List)EyeConfig.eye_ops.get()).contains(user.m_6302_());
        boolean OP = world.m_7654_().m_6846_().m_11303_(user.m_36316_());
        return OP || opConfig;
    }

    private String getUniqueID(Level world) {
        int id = (int)(world.m_8044_() + (long)world.m_213780_().m_188503_(99999));
        return "1_" + id;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos bp = context.m_8083_();
        BlockState bs = context.m_43725_().m_8055_(bp);
        if (bs.m_60734_() == Eye.ROUTER.get()) {
            return this.useOnRouter(context.m_43725_(), context.m_43723_(), bs, context.m_43722_(), bp);
        }
        if (bs.m_60734_() == Eye.CHARGER.get()) {
            return this.useOnCharger(context.m_43725_(), bs, context.m_43722_(), bp);
        }
        return super.m_6225_(context);
    }

    public InteractionResult useOnCharger(Level world, BlockState state, ItemStack stack, BlockPos pos) {
        CompoundTag nbt = stack.m_41783_();
        int lvl = (Integer)state.m_61143_((Property)Charger.LEVEL);
        if (lvl >= 1) {
            if (stack.m_41773_() > 0) {
                int nb = stack.m_41773_() - 10;
                stack.m_41721_(nb < 0 ? 0 : nb);
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)Charger.LEVEL, (Comparable)Integer.valueOf(lvl - 1)));
                if (world.m_5776_()) {
                    if (lvl - 1 <= 0) {
                        Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11778_, 1.0f, 1.0f);
                    } else {
                        Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_144181_, 1.0f, 1.0f);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult useOnRouter(Level world, Player user, BlockState state, ItemStack stack, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)Router.ON)).booleanValue()) {
            if (world.m_7702_(pos) instanceof RouterEntity) {
                boolean canOpen;
                RouterEntity re = (RouterEntity)world.m_7702_(pos);
                String routerOwner = re.owner;
                String routerPass = re.password;
                boolean bl = canOpen = routerOwner.equals(stack.m_41783_().m_128461_("user")) || routerPass.equals(stack.m_41783_().m_128461_("net")) || routerPass.isEmpty();
                if (!world.m_5776_()) {
                    InteractionHand hand = user.m_21205_().m_41720_() instanceof ItemDevice ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                    PacketHandler.INSTANCE.send(PacketDistributor.DIMENSION.with(() -> world.m_46472_()), (Object)new ClientGuiOpen(user.m_6302_(), hand, new Pos(pos, world.m_46472_().m_135782_()), canOpen));
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (world.m_5776_()) {
            this.sendMsg("text.eyemod.block_router_off");
        }
        return InteractionResult.SUCCESS;
    }

    public void sendMsg(String msg) {
        Minecraft.m_91087_().f_91074_.m_5661_((Component)new Line(msg).asText(), true);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.m_5776_()) {
            if (selected) {
                this.messageHandler(stack);
            }
            this.batteryTick(world.f_46441_, stack, selected);
        } else {
            this.timerTick(stack);
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void messageHandler(ItemStack stack) {
        ListTag msgs = stack.m_41783_().m_128437_("_msgs", (int)Naming.Type.COMPOUND.type);
        if (msgs.size() <= 0) {
            return;
        }
        CompoundTag msg = msgs.m_128728_(0);
        msgs.remove(0);
        if (!msg.m_128441_("id")) {
            return;
        }
        EyeMsgHandler.messages.get(msg.m_128451_("id")).handle(stack, msg);
        stack.m_41783_().m_128365_("_msgs", (Tag)msgs);
    }

    public void batteryTick(RandomSource random, ItemStack stack, boolean selected) {
        if (stack.m_41773_() < stack.m_41776_()) {
            int min = 120;
            int range = 20 * (min <= 0 ? 1 : min);
            int n = range = selected ? range : range * 60;
            if (random.m_188503_(range) < 1) {
                stack.m_41721_(stack.m_41773_() + 1);
            }
        }
    }

    public void timerTick(ItemStack stack) {
        ArrayList<Timer> remove = new ArrayList<Timer>();
        for (Timer t : this.timers) {
            if (!stack.m_41783_().m_128461_("ID").equals(t.getDeviceID())) continue;
            t.tick();
            if (!t.done()) continue;
            remove.add(t);
        }
        this.timers.removeAll(remove);
    }
}

