/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.util.commands;

import com.podloot.eyemod.gui.GuiDevice;
import com.podloot.eyemod.gui.util.commands.Command;
import com.podloot.eyemod.lib.gui.EyeLib;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class CommandWorld
extends Command {
    public CommandWorld() {
        super("world", new String[]{"entities", "players"}, false);
        this.help = this.help + " [range]";
    }

    @Override
    public String run(String[] args, GuiDevice device, boolean op) {
        if (args.length <= 1) {
            return this.help;
        }
        BlockPos bp = device.getUser().m_20183_();
        switch (args[1]) {
            case "entities": {
                int range = 32;
                if (args.length > 2) {
                    range = EyeLib.getInt(args[2]);
                }
                List list = device.getUser().f_19853_.m_45933_((Entity)Minecraft.m_91087_().f_91074_, new AABB(bp.m_7918_(-range, -range, -range), bp.m_7918_(range, range, range)));
                return "Entities within " + range + " blocks: " + list.size();
            }
            case "players": {
                List players = device.getUser().f_19853_.m_6907_();
                if (args.length > 2) {
                    int prange = EyeLib.getInt(args[2]);
                    return "Players within " + prange + " blocks: " + this.getPlayers(players, bp, prange);
                }
                return "Amount of players in world: " + players.size();
            }
        }
        return null;
    }

    private int getPlayers(List<? extends Player> players, BlockPos bp, int range) {
        int a = 0;
        for (Player player : players) {
            BlockPos pp = player.m_20183_();
            int dx = Math.abs(pp.m_123341_() - bp.m_123341_());
            int dy = Math.abs(pp.m_123342_() - bp.m_123342_());
            int dz = Math.abs(pp.m_123343_() - bp.m_123343_());
            if (dx > range || dy > range || dz > range) continue;
            ++a;
        }
        return a - 1;
    }
}

