/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.util.commands;

import com.podloot.eyemod.EyeClient;
import com.podloot.eyemod.EyeCommands;
import com.podloot.eyemod.gui.GuiDevice;
import com.podloot.eyemod.gui.util.commands.Command;

public class CommandHelp
extends Command {
    public CommandHelp() {
        super("help", new String[0], false, true);
        this.sub = new String[EyeCommands.getCommands().size()];
        int i = 0;
        for (Command c : EyeCommands.getCommands()) {
            if (this.sub.length < i) {
                this.sub[i] = c.cmd;
            }
            ++i;
        }
        this.help = "Use: help <command>";
    }

    @Override
    public String run(String[] args, GuiDevice device, boolean op) {
        if (args.length == 1) {
            Object commands = "Use: help <command> | Commands:";
            for (Command c : EyeCommands.getCommands()) {
                if (!c.alwaysUsable && !device.isInstalled(EyeClient.APPCONSOLE.getId())) continue;
                commands = (String)commands + " | - " + c.getCommand() + (c.isOP ? "*" : "");
            }
            commands = (String)commands + " | Note: * = operators only";
            return commands;
        }
        if (args.length >= 2) {
            Command toHelp = this.getCmd(args[1]);
            if (toHelp != null) {
                return toHelp.getHelp();
            }
            return "Non existing command";
        }
        return null;
    }

    public Command getCmd(String cmd) {
        for (Command c : EyeCommands.getCommands()) {
            if (!c.getCommand().equals(cmd)) continue;
            return c;
        }
        return null;
    }
}

