/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.util.commands;

import com.podloot.eyemod.gui.GuiDevice;
import com.podloot.eyemod.gui.util.NbtManager;
import com.podloot.eyemod.gui.util.commands.Command;

public class CommandDevice
extends Command {
    public CommandDevice() {
        super("device", new String[]{"reset", "storage", "battery", "close"}, false, true);
    }

    @Override
    public String run(String[] args, GuiDevice device, boolean op) {
        if (args.length <= 1) {
            return this.help;
        }
        switch (args[1]) {
            case "storage": {
                NbtManager cfr_ignored_0 = device.data;
                int gb = NbtManager.getStorage(device.data.getNbt());
                int mgb = device.data.getInt("storage");
                return "Storage: " + gb + "GB / " + mgb + "GB";
            }
            case "reset": {
                device.clearAll();
                return "Device cleared";
            }
            case "battery": {
                int m = device.getItem().m_41776_();
                int b = m - device.getItem().m_41773_();
                return "Battery: " + b + "/" + m;
            }
            case "close": {
                device.closeDevice();
                return "Closed device";
            }
        }
        return null;
    }
}

