/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.util.commands;

import com.podloot.eyemod.EyeApps;
import com.podloot.eyemod.EyeClient;
import com.podloot.eyemod.gui.GuiDevice;
import com.podloot.eyemod.gui.apps.App;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public abstract class Command {
    ResourceLocation id;
    String cmd;
    String help;
    boolean isOP = false;
    boolean alwaysUsable = false;
    String[] sub;

    public Command(String cmd, String[] sub, boolean OP) {
        this(cmd, sub, OP, false);
    }

    public Command(String cmd, String[] sub, boolean OP, boolean alwaysUsable) {
        this.cmd = cmd;
        this.sub = sub;
        this.help = this.getHelpLine();
        this.isOP = OP;
        this.alwaysUsable = alwaysUsable;
    }

    public String getHelpLine() {
        Object h = "Use: " + this.cmd + " <";
        for (String s : this.sub) {
            h = (String)h + s + "/";
        }
        h = ((String)h).substring(0, ((String)h).length() - 1);
        return (String)h + ">";
    }

    public String execute(String[] args, GuiDevice device, boolean operator) {
        if (this.isOP && !operator) {
            return "You are not allowed to run this command";
        }
        if (!this.alwaysUsable && !device.isInstalled(EyeClient.APPCONSOLE.getId())) {
            return "You need to install the app to use this command";
        }
        return this.run(args, device, operator);
    }

    public abstract String run(String[] var1, GuiDevice var2, boolean var3);

    public BlockPos getPos(String x, String y, String z) {
        BlockPos player = Minecraft.m_91087_().f_91074_.m_20183_();
        return new BlockPos(this.getPosInt(x, player.m_123341_()), this.getPosInt(y, player.m_123342_()), this.getPosInt(z, player.m_123343_()));
    }

    private int getPosInt(String s, int tilt) {
        Object object = s = ((String)s).isEmpty() || ((String)s).equals("") || !((String)s).matches("[0-9~-]+") ? "~" : s;
        if (((String)s).contains("-")) {
            s = "-" + ((String)s).replace("-", "");
        }
        if (((String)s).contains("~")) {
            String v = ((String)s).replace("~", "");
            return Integer.valueOf(v.equals("") ? "0" : v) + tilt;
        }
        return Integer.valueOf((String)s);
    }

    public ResourceLocation getWorld(String world) {
        if (!world.contains(":")) {
            return new ResourceLocation("minecraft:" + world);
        }
        return new ResourceLocation(world);
    }

    public ResourceLocation getApp(String id) {
        if (!id.contains(":")) {
            for (App a : EyeApps.getApps()) {
                if (!a.getId().m_135815_().equals(id)) continue;
                return a.getId();
            }
        }
        return new ResourceLocation(id);
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getCommand() {
        return this.cmd;
    }

    public String getHelp() {
        return this.help;
    }

    public String[] getSub() {
        return this.sub;
    }
}

