/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.util;

public class Timer {
    String deviceID;
    String name = "Timer";
    boolean done = false;
    boolean stopwatch = false;
    int ticks = 0;
    int s = 0;
    Runnable run;
    Runnable tick;
    public boolean pause;

    public Timer(String deviceid, String name, Runnable run, int seconds) {
        this.deviceID = deviceid;
        this.name = name;
        this.run = run;
        this.ticks = seconds * 20;
    }

    public void setTick(Runnable tick, int s) {
        this.tick = tick;
        this.s = s <= 0 ? 1 : s;
    }

    public void setStopwatch() {
        this.stopwatch = true;
    }

    public void tick() {
        if (this.pause || this.done) {
            return;
        }
        if (this.ticks >= 20 || this.stopwatch) {
            if (this.tick != null && this.ticks % this.s == 0) {
                this.tick.run();
            }
            this.ticks += this.stopwatch ? 1 : -1;
        } else {
            this.run.run();
            this.done = true;
        }
    }

    public boolean done() {
        return this.done;
    }

    public String getTime() {
        int total = this.ticks / 20;
        int minutes = total / 60;
        int seconds = total % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    public String getName() {
        return this.name;
    }

    public boolean isStopwatch() {
        return this.stopwatch;
    }

    public String getDeviceID() {
        return this.deviceID;
    }
}

