/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.util;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.podloot.eyemod.Eye;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;

public class Photos {
    public static int[] toArray(NativeImage image, int comp) {
        int nw = image.m_84982_() / comp;
        int nh = image.m_85084_() / comp;
        int[] array = new int[nw * nh + 1];
        array[0] = nw;
        for (int i = 0; i < nw; ++i) {
            for (int j = 0; j < nh; ++j) {
                int id = i + j * nw + 1;
                array[id] = image.m_84985_(i * comp, j * comp);
            }
        }
        return array;
    }

    public static NativeImage toImage(int[] array) {
        NativeImage img = new NativeImage(array[0], (array.length - 1) / array[0], false);
        try {
            for (int i = 0; i < img.m_84982_(); ++i) {
                for (int j = 0; j < img.m_85084_(); ++j) {
                    img.m_84988_(i, j, array[i + j * array[0] + 1]);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return img;
    }

    public static List<String> getPhotos() {
        File file = new File(Minecraft.m_91087_().f_91069_, "screenshots/eyemod");
        File[] files = file.listFiles();
        ArrayList<String> names = new ArrayList<String>();
        if (!file.exists()) {
            return names;
        }
        for (File f : files) {
            NativeImage i;
            if (!f.getName().endsWith(".png") || (i = Photos.readShot(f.getName())).m_84982_() > 600 || i.m_85084_() > 800) continue;
            names.add(f.getName());
        }
        return names;
    }

    public static NativeImage readShot(String name) {
        File file;
        if (!((String)name).contains(".png")) {
            name = (String)name + ".png";
        }
        if (!(file = new File(Minecraft.m_91087_().f_91069_, "screenshots/eyemod/" + (String)name)).exists()) {
            return null;
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            NativeImage img = NativeImage.m_85058_((InputStream)inputStream);
            return img;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean takeShot(String name) {
        double sf;
        NativeImage img = Screenshot.m_92279_((RenderTarget)Minecraft.m_91087_().m_91385_());
        double s = sf = Minecraft.m_91087_().m_91268_().m_85449_();
        NativeImage im = new NativeImage((int)(148.0 * s), (int)(192.0 * s), false);
        int mw = Minecraft.m_91087_().m_91268_().m_85441_();
        int mh = Minecraft.m_91087_().m_91268_().m_85442_();
        double ow = mw / 2 - im.m_84982_() / 2;
        double oh = mh / 2 - im.m_85084_() / 2;
        try {
            for (int i = 0; i < im.m_84982_(); ++i) {
                for (int j = 0; j < im.m_85084_(); ++j) {
                    int ix = (int)((double)i + ow);
                    int iy = (int)((double)j + oh);
                    if (ix >= img.m_84982_() || iy >= img.m_85084_() || ix < 0 || iy < 0) continue;
                    im.m_84988_(i, j, img.m_84985_(ix, iy + (int)s));
                }
            }
            img.close();
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return Photos.saveShot(name + ".png", im);
    }

    public static boolean takeShotLow(String name) {
        double sf;
        NativeImage img = Screenshot.m_92279_((RenderTarget)Minecraft.m_91087_().m_91385_());
        NativeImage im = new NativeImage(148, 192, false);
        int mw = Minecraft.m_91087_().m_91268_().m_85441_();
        int mh = Minecraft.m_91087_().m_91268_().m_85442_();
        double s = sf = Minecraft.m_91087_().m_91268_().m_85449_();
        double ow = (double)(mw / 2) - 74.0 * s;
        double oh = (double)(mh / 2) - 96.0 * s;
        try {
            for (int i = 0; i < im.m_84982_(); ++i) {
                for (int j = 0; j < im.m_85084_(); ++j) {
                    int ix = (int)((double)i * s + ow);
                    int iy = (int)((double)j * s + oh);
                    if (ix >= img.m_84982_() || iy >= img.m_85084_() || ix < 0 || iy < 0) continue;
                    im.m_84988_(i, j, img.m_84985_(ix, iy + (int)s));
                }
            }
            img.close();
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return Photos.saveShot(name + ".png", im);
    }

    public static boolean saveShot(String fileName, NativeImage nativeImage) {
        File screenshot = new File(Minecraft.m_91087_().f_91069_, "screenshots/");
        screenshot.mkdir();
        File file = new File(screenshot, "eyemod/");
        file.mkdir();
        File file2 = new File(file, fileName);
        if (file2.exists()) {
            return false;
        }
        Util.m_183991_().execute(() -> {
            try {
                nativeImage.m_85056_(file2);
            }
            catch (Exception text) {
                Eye.LOGGER.warn("Couldn't save screenshot", (Throwable)text);
            }
            finally {
                nativeImage.close();
            }
        });
        return true;
    }

    public static boolean deleteShot(String filename) {
        File file;
        if (!((String)filename).contains(".png")) {
            filename = (String)filename + ".png";
        }
        if ((file = new File(Minecraft.m_91087_().f_91069_, "screenshots/eyemod/" + (String)filename)).exists()) {
            return file.delete();
        }
        return false;
    }

    public static boolean renameShot(String filename, String newname) {
        if (!((String)filename).contains(".png")) {
            filename = (String)filename + ".png";
        }
        if (!((String)newname).contains(".png")) {
            newname = (String)newname + ".png";
        }
        try {
            File file = new File(Minecraft.m_91087_().f_91069_, "screenshots/eyemod/" + (String)filename);
            File destfile = new File(Minecraft.m_91087_().f_91069_, "screenshots/eyemod/" + (String)newname);
            if (!file.exists()) {
                return false;
            }
            if (destfile.exists()) {
                return false;
            }
            Path source = Paths.get(file.getPath(), new String[0]);
            Files.move(source, source.resolveSibling((String)newname), new CopyOption[0]);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

