/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.util;

import com.podloot.eyemod.Eye;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.items.ItemDevice;
import com.podloot.eyemod.lib.gui.util.Pos;
import com.podloot.eyemod.network.PacketHandler;
import com.podloot.eyemod.network.ServerNbtReplace;
import com.podloot.eyemod.network.ServerNbtSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class NbtManager {
    private InteractionHand hand = InteractionHand.MAIN_HAND;
    private int saving = -1;
    public int max_storage = 256;

    public NbtManager(InteractionHand hand) {
        this.hand = hand;
        this.max_storage = this.getInt("storage");
    }

    public boolean has(String key) {
        return this.getNbt().m_128441_(key);
    }

    public void setCompoundTag(String key, CompoundTag value) {
        this.sendNbt(key, (Tag)value);
    }

    public CompoundTag getCompoundTag(String key) {
        return this.getNbt().m_128469_(key);
    }

    public void setString(String key, String value) {
        this.sendNbt(key, (Tag)StringTag.m_129297_((String)value));
    }

    public String getString(String key) {
        return this.getNbt().m_128461_(key);
    }

    public void setInt(String key, int value) {
        this.sendNbt(key, (Tag)IntTag.m_128679_((int)value));
    }

    public void addInt(String key, int add) {
        this.sendNbt(key, (Tag)IntTag.m_128679_((int)(this.getInt(key) + add)));
    }

    public int getInt(String key) {
        return this.getNbt().m_128451_(key);
    }

    public void setBool(String key, boolean value) {
        this.sendNbt(key, (Tag)ByteTag.m_128273_((boolean)value));
    }

    public boolean getBool(String key) {
        return this.getNbt().m_128471_(key);
    }

    public boolean toggleBool(String key) {
        boolean v = this.getBool(key);
        this.setBool(key, !v);
        return !v;
    }

    public void setPos(String key, Pos pos) {
        this.setString(key, pos.toNbt());
    }

    public Pos getPos(String key) {
        String bp = this.getString(key);
        return new Pos().fromString(bp);
    }

    public void setPosList(String key, List<Pos> pos) {
        ListTag poss = new ListTag();
        for (Pos p : pos) {
            poss.add((Object)StringTag.m_129297_((String)p.toNbt()));
        }
        this.setList(key, poss);
    }

    public List<Pos> getPosList(String key) {
        ListTag poss = this.getList(key, (byte)8);
        ArrayList<Pos> pos = new ArrayList<Pos>();
        for (int i = 0; i < poss.size(); ++i) {
            String p = poss.m_128778_(i);
            pos.add(new Pos().fromString(p));
        }
        return pos;
    }

    public void setList(String key, ListTag list) {
        this.sendNbt(key, (Tag)list);
    }

    public void addToList(String key, Tag item) {
        this.addToList(key, -1, item);
    }

    public void addToList(String key, int index, Tag item) {
        ListTag list = this.getList(key, item.m_7060_());
        if (index < 0 || index >= list.size()) {
            list.add((Object)item);
        } else {
            list.set(index, item);
        }
        this.setList(key, list);
    }

    public void removeFromList(String key, Tag item) {
        ListTag list = this.getList(key, item.m_7060_());
        list.remove((Object)item);
        this.setList(key, list);
    }

    public void removeFromList(String key, int index) {
        if (this.getNbt().m_128423_(key).m_7060_() != Naming.Type.LIST.type) {
            return;
        }
        ListTag list = (ListTag)this.getNbt().m_128423_(key);
        index = index < 0 ? list.size() - 1 : (index >= list.size() - 1 ? list.size() - 1 : index);
        list.remove(index);
        this.setList(key, list);
    }

    public ListTag getList(String key, Naming.Type type) {
        CompoundTag nbt = this.getNbt();
        ListTag list = nbt.m_128437_(key, (int)type.type);
        return list;
    }

    public ListTag getList(String key, byte type) {
        CompoundTag nbt = this.getNbt();
        ListTag list = nbt.m_128437_(key, (int)type);
        return list;
    }

    public void remove(String key) {
        CompoundTag nbt = this.getNbt();
        nbt.m_128473_(key);
        PacketHandler.INSTANCE.sendToServer((Object)new ServerNbtReplace(nbt, this.hand));
    }

    public CompoundTag getNbt() {
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21120_(this.hand);
        if (stack != null && stack.m_41720_() instanceof ItemDevice) {
            return stack.m_41783_();
        }
        Eye.LOGGER.warn("Failed to retrieve nbt data, returned empty one.");
        return new CompoundTag();
    }

    public void updateNbt(CompoundTag nbt) {
        PacketHandler.INSTANCE.sendToServer((Object)new ServerNbtReplace(nbt, this.hand));
    }

    public void sendNbt(String key, Tag element) {
        PacketHandler.INSTANCE.sendToServer((Object)new ServerNbtSet(key, element, this.hand));
    }

    public static int getStorage(CompoundTag nbt) {
        Set keys = nbt.m_128431_();
        int storage = 0;
        for (String k : keys) {
            if (nbt.m_128423_(k).m_6458_() == ListTag.f_128714_) {
                storage += ((ListTag)nbt.m_128423_(k)).size();
                continue;
            }
            if (nbt.m_128423_(k).m_6458_() == CompoundTag.f_128326_) {
                storage += ((CompoundTag)nbt.m_128423_(k)).m_128440_();
                continue;
            }
            if (nbt.m_128423_(k).m_6458_() == IntArrayTag.f_128599_) {
                storage += nbt.m_128465_(k).length;
                continue;
            }
            ++storage;
        }
        return storage;
    }

    public boolean hasStorage() {
        return NbtManager.getStorage(this.getNbt()) < this.max_storage;
    }

    public boolean saving() {
        return this.saving >= 0;
    }

    public void update() {
        if (this.saving >= 0) {
            --this.saving;
        }
    }
}

