/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.util;

import com.podloot.eyemod.EyeClient;
import com.podloot.eyemod.blocks.Router;
import com.podloot.eyemod.blocks.entities.RouterEntity;
import com.podloot.eyemod.gui.GuiDevice;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.util.Pos;
import com.podloot.eyemod.network.PacketHandler;
import com.podloot.eyemod.network.ServerSendChat;
import com.podloot.eyemod.network.ServerSendMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class ConnectionManager {
    GuiDevice device;
    public int max_distance = 512;

    public ConnectionManager(GuiDevice device) {
        this.device = device;
        this.max_distance = device.config.getInt("router_range");
    }

    public void sendMessage(String rec, String msg) {
        if (this.isConnected()) {
            if (msg.startsWith("\\|")) {
                msg = msg.substring(1);
            }
            if (msg.isEmpty()) {
                return;
            }
            CompoundTag messages = this.device.data.getCompoundTag("messages");
            ListTag conv = messages.m_128437_(rec, (int)Naming.Type.STRING.type);
            conv.add((Object)StringTag.m_129297_((String)("|" + msg)));
            messages.m_128365_(rec, (Tag)conv);
            this.device.data.setCompoundTag("messages", messages);
            Pos router = this.getRouter();
            CompoundTag msg_data = new CompoundTag();
            msg_data.m_128359_("sen", this.device.getOwner());
            msg_data.m_128359_("msg", msg);
            PacketHandler.INSTANCE.sendToServer((Object)new ServerSendMessage(router, Naming.Msg.MESSAGE, rec, msg_data));
        }
    }

    public void sendChat(String msg, String channel) {
        int d = this.device.settings.getInt("chat_dis");
        d = d < 0 ? -1 : (d == 0 ? 16 : 16 * d);
        PacketHandler.INSTANCE.sendToServer((Object)new ServerSendChat(this.device.getOwner(), msg, this.device.settings.getBool("chat_local"), d));
    }

    public void sendMail(String sender, String subject, String message) {
        String mail = sender + "~" + subject + "~" + message;
        ListTag mails = this.device.data.getList("mail", Naming.Type.STRING);
        if (mails.size() > 8) {
            for (int i = 0; i < mails.size() - 8; ++i) {
                mails.remove(i);
            }
        }
        mails.add((Object)StringTag.m_129297_((String)mail));
        this.device.addNotification(EyeClient.APPMAIL.getId(), "From: " + sender);
        this.device.data.setList("mail", mails);
    }

    public boolean isConnected() {
        return this.getConnection() > 0;
    }

    public int getConnection() {
        Pos router = this.device.data.getPos("router");
        return this.getConnection(router);
    }

    public int getConnection(Pos router) {
        int distance = this.getDistance();
        if (distance < 0) {
            return 0;
        }
        if (!((Boolean)this.device.getUser().m_9236_().m_8055_(router.getPos()).m_61143_((Property)Router.ON)).booleanValue()) {
            return 0;
        }
        String pass = "";
        String owner = "";
        if (pass.isEmpty() || pass.equals(this.device.data.getString("net_pw")) || owner == this.device.getUser().m_6302_()) {
            if (this.max_distance == 0) {
                return 3;
            }
            float steps = (float)this.max_distance / 3.0f;
            if ((float)distance < steps) {
                return 3;
            }
            if ((float)distance < steps * 2.0f) {
                return 2;
            }
            if (distance < this.max_distance) {
                return 3;
            }
        }
        return 0;
    }

    public boolean isRouter(Pos router) {
        if (router == null) {
            return false;
        }
        return this.device.getUser().m_9236_().m_7702_(router.getPos()) instanceof RouterEntity;
    }

    public int getDistance() {
        Pos router = this.getRouter();
        if (router == null) {
            return -1;
        }
        if (!this.isRouter(router)) {
            return -1;
        }
        if (!router.getWorld().equals((Object)this.device.getWorldID())) {
            return -1;
        }
        BlockPos player = this.device.getUser().m_20183_();
        int distance = player.m_123333_((Vec3i)router.getPos());
        return distance;
    }

    public int getReach() {
        ResourceLocation w = this.device.getWorldID();
        if (w.equals((Object)Naming.Dim.OVERWORLD.id)) {
            return 3;
        }
        if (w.equals((Object)Naming.Dim.NETHER.id)) {
            return 2;
        }
        if (w.equals((Object)Naming.Dim.END.id)) {
            return 1;
        }
        return this.device.getUser().m_9236_().f_46441_.m_188503_(4);
    }

    public Pos getRouter() {
        return this.device.data.getPos("router");
    }

    public RouterEntity getRouterData() {
        Pos pos = this.getRouter();
        if (pos == null) {
            return null;
        }
        BlockEntity be = this.device.getUser().f_19853_.m_7702_(pos.getPos());
        if (be instanceof RouterEntity) {
            return (RouterEntity)be;
        }
        return null;
    }
}

