/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.presets;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.presets.Preset;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeTextField;

public class TimerPreset
extends Preset {
    EyeTextField min;
    EyeTextField sec;

    public TimerPreset(App app, int width, int height) {
        super(app, width, height);
        this.min = new EyeTextField(width / 2 - 2, height);
        this.sec = new EyeTextField(width / 2 - 2, height);
        this.min.setHover(new Line("text.eyemod.minutes"));
        this.sec.setHover(new Line("text.eyemod.seconds"));
        this.min.setText(new Line("00"));
        this.sec.setText(new Line("00"));
        this.min.setAllowed("[0-9]+");
        this.sec.setAllowed("[0-9]+");
        this.min.setLimit(2);
        this.sec.setLimit(2);
        this.add(this.min, 0, 0);
        this.add(this.sec, width / 2 + 2, 0);
        EyeLabel lbl = new EyeLabel(width, height, new Line(":"));
        this.add(lbl, 0, 0);
    }

    public int getTime() {
        return this.getTime(this.min.getInput(), this.sec.getInput());
    }

    private int getTime(String input, String input2) {
        int m = 0;
        int s = 0;
        if (input.matches("[0-9]+")) {
            m = Integer.valueOf(input);
        }
        if (input2.matches("[0-9]+")) {
            s = Integer.valueOf(input2);
        }
        return m * 60 + s;
    }

    public void setTime(int min, int sec) {
        this.min.setInput("" + min);
        this.sec.setInput("" + sec);
    }
}

