/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.presets;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.presets.Preset;
import com.podloot.eyemod.gui.util.Timer;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeList;
import com.podloot.eyemod.lib.gui.widgets.EyeVariable;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;

public class TimerListPreset
extends Preset {
    EyeList timers = null;
    String filter = null;

    public TimerListPreset(App app, int width, int height, String filter) {
        super(app, width, height);
        this.setFilter(filter);
    }

    public void setFilter(String name) {
        this.filter = name;
        this.refresh();
    }

    public void loadList() {
        this.timers = new EyeList(this.getWidth(), this.getHeight(), EyeWidget.Axis.VERTICAL);
        for (Timer t : this.app.getDevice().getTimers()) {
            if (t.getDeviceID() != this.app.getDevice().getUniqueID() || this.filter != null && !t.getName().equals(this.filter)) continue;
            this.timers.add(this.getTimerPanel(t));
        }
        this.add(this.timers, 0, 0);
    }

    public EyePanel getTimerPanel(Timer timer) {
        EyePanel pan = new EyePanel(this.getWidth() - 10, 34);
        pan.setBack(-12303292);
        EyeLabel name = new EyeLabel(this.getWidth() - 10 - 42 - 40, 14, new Line(timer.getName()));
        name.setBack(this.app.getAppColor());
        EyeLabel type = new EyeLabel(60, 14, timer.isStopwatch() ? new Line("text.eyemod.clock_stopwatch") : new Line("text.eyemod.clock_timer"));
        type.setBack(this.app.getAppColor());
        pan.add(name, 2, 2);
        pan.add(type, pan.getWidth() - 42 - 36, 2);
        EyeButton del = new EyeButton(14, 14, EyeLib.DELETE);
        del.setColor(-12303292, -292985);
        del.setAction(() -> {
            this.app.getDevice().stopTimer(timer);
            this.refresh();
        });
        pan.add(del, this.getWidth() - 10 - 16, 2);
        EyeVariable time = new EyeVariable(this.getWidth() - 10 - 20, 14, new Line("{v}"));
        time.setBack(this.app.getAppColor());
        time.setVariable(() -> timer.getTime());
        pan.add(time, 18, 18);
        EyeButton pause = new EyeButton(14, 14, EyeLib.PLAY);
        pause.setAction(() -> {
            if (timer.pause) {
                timer.pause = false;
                time.setText(time.getText().setStyle(false, false));
                pause.setIcon(EyeLib.PLAY);
            } else {
                timer.pause = true;
                time.setText(time.getText().setStyle(false, true));
                pause.setIcon(EyeLib.PAUSE);
            }
        });
        pan.add(pause, 2, 18);
        return pan;
    }

    public void refresh() {
        if (this.timers != null) {
            this.timers.clearList();
            this.remove(this.timers);
        }
        this.loadList();
    }
}

