/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.presets;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.panes.ListPane;
import com.podloot.eyemod.gui.presets.PresetInput;
import com.podloot.eyemod.lib.gui.panels.EyeListPanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import java.util.ArrayList;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;

public class PotionPreset
extends PresetInput {
    MobEffect[] effects;

    public PotionPreset(App app, int width, MobEffect[] effects) {
        super(app, width, 32, new Line("text.eyemod.effect"));
        this.effects = effects;
        this.name.setAllowed("[a-zA-Z_ ]+");
        this.name.setSuggest(this.getNames(effects));
        EyeButton p = this.getListButton(new Line("text.eyemod.positive"), -10896292, this.getEffects(MobEffectCategory.BENEFICIAL));
        this.add(p, 0, 18);
        EyeButton e = this.getListButton(new Line("text.eyemod.neutral"), app.appColor, this.getEffects(MobEffectCategory.NEUTRAL));
        this.add(e, width / 2 - 24, 18);
        EyeButton n = this.getListButton(new Line("text.eyemod.negative"), -292985, this.getEffects(MobEffectCategory.HARMFUL));
        this.add(n, this.getWidth() - 48, 18);
    }

    public int getEffect() {
        String in = this.getInput();
        for (MobEffect s : this.effects) {
            if (!s.m_19482_().getString().equals(in)) continue;
            return MobEffect.m_19459_((MobEffect)s);
        }
        return 0;
    }

    public MobEffect[] getEffects(MobEffectCategory cat) {
        ArrayList<MobEffect> se = new ArrayList<MobEffect>();
        for (MobEffect s : this.effects) {
            if (s.m_19483_() != cat) continue;
            se.add(s);
        }
        return se.toArray(new MobEffect[0]);
    }

    public String[] getNames(MobEffect[] lib) {
        String[] names = new String[lib.length];
        for (int i = 0; i < lib.length; ++i) {
            names[i] = lib[i].m_19482_().getString();
        }
        return names;
    }

    public EyeButton getListButton(Line name, int color, MobEffect[] lib) {
        EyeButton button = new EyeButton(48, 14, name);
        button.setColor(color);
        button.setAction(() -> {
            ListPane list = new ListPane(this.app, this.app.getWidth() - 4, this.app.getHeight() - 4);
            for (int i = 0; i < lib.length; ++i) {
                EyeListPanel pan = new EyeListPanel(list.getList(), 14);
                EyeLabel lbl = new EyeLabel(pan.getWidth(), pan.getHeight(), new Line(lib[i].m_19482_().getString()));
                pan.setData(lib[i].m_19482_().getString());
                lbl.setBack(color);
                pan.add(lbl, 0, 0);
                list.getList().add(pan);
            }
            list.setAction(() -> {
                if (list.getSelected() != null) {
                    this.name.setInput("" + list.getSelected().getData());
                }
            });
            this.app.openPane(list);
        });
        return button;
    }

    public void combine() {
    }
}

