/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.presets;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.elements.DimensionButton;
import com.podloot.eyemod.gui.panes.MapPane;
import com.podloot.eyemod.gui.panes.WaypointPane;
import com.podloot.eyemod.gui.presets.Preset;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Pos;
import com.podloot.eyemod.lib.gui.util.Space;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class PosPreset
extends Preset {
    DimensionButton dim;
    EyeButton select;
    EyeTextField x;
    EyeTextField y;
    EyeTextField z;
    HitResult blockHit;

    public PosPreset(App app, int width) {
        super(app, width, 32);
        this.dim = new DimensionButton(14, 14, (Level)Minecraft.m_91087_().f_91073_);
        this.dim.setHover(new Line("text.eyemod.hover_dimension"));
        int w = width - 14;
        int s = (w - 4) / 3;
        BlockPos bp = app.getDevice().getUser().m_20183_();
        this.x = new EyeTextField(s, 16);
        this.x.setText(new Line("X"));
        this.x.setAllowed("[0-9~-]+");
        this.x.setSuggest(new String[]{"" + bp.m_123341_()});
        this.y = new EyeTextField(s, 16);
        this.y.setText(new Line("Y"));
        this.y.setAllowed("[0-9~-]+");
        this.y.setSuggest(new String[]{"" + bp.m_123342_()});
        this.z = new EyeTextField(s, 16);
        this.z.setText(new Line("Z"));
        this.z.setAllowed("[0-9~-]+");
        this.z.setSuggest(new String[]{"" + bp.m_123343_()});
        this.add(this.x, 0, 0);
        this.add(this.y, w / 2 - s / 2 - 1, 0);
        this.add(this.z, w / 2 + s / 2 + 1, 0);
        this.add(this.dim, width - 14, 1);
        EyeButton current = new EyeButton(14, 14, EyeLib.POSITION);
        current.setColor(-3223858, -1);
        current.setHover(new Line("text.eyemod.hover_currentpos"));
        EyeButton way = new EyeButton(14, 14, EyeLib.WAYPOINT);
        way.setColor(-3223858, -1);
        way.setHover(new Line("text.eyemod.hover_waypoints"));
        EyeButton map = new EyeButton(14, 14, EyeLib.MAP);
        map.setColor(-3223858, -1);
        map.setHover(new Line("text.eyemod.hover_mappos"));
        EyeButton look = new EyeButton(14, 14, EyeLib.LOOKING);
        look.setColor(-3223858, -1);
        look.setHover(new Line("text.eyemod.hover_lookingat"));
        current.setAction(() -> {
            this.x.setInput("~");
            this.y.setInput("~");
            this.z.setInput("~");
        });
        way.setAction(() -> {
            WaypointPane l = new WaypointPane(app, app.getWidth() - 4, app.getHeight() - 22);
            l.addItems(app.getDevice().data.getList("waypoints", Naming.Type.STRING));
            l.setAction(() -> {
                String sp = (String)l.getData();
                if (sp != null) {
                    this.setInput(new Pos().fromString(sp));
                }
            });
            app.openPane(l);
        });
        map.setAction(() -> {
            MapPane m = new MapPane(app, app.getWidth() - 4, app.getHeight() - 22);
            m.setAction(() -> this.setInput(m.getPos().m_7918_(0, 1, 0), m.getWorld()));
            app.openPane(m);
        });
        look.setAction(() -> {
            BlockPos data;
            this.blockHit = app.getDevice().getUser().m_19907_(100.0, 0.0f, false);
            if (this.blockHit.m_6662_() == HitResult.Type.BLOCK && (data = ((BlockHitResult)this.blockHit).m_82425_()) != null) {
                this.setInput(data.m_7918_(0, 1, 0), app.getDevice().getWorldID());
            }
        });
        this.add(current, 0, 18);
        this.add(way, 16, 18);
        this.add(map, 32, 18);
        this.add(look, 48, 18);
    }

    public void setInput(BlockPos pos, ResourceLocation world) {
        if (pos != null) {
            this.x.setInput("" + pos.m_123341_());
            this.y.setInput("" + pos.m_123342_());
            this.z.setInput("" + pos.m_123343_());
            if (world != null) {
                this.dim.setDimension(world);
            }
        }
    }

    public void setInput(Pos m) {
        BlockPos pos = m.getPos();
        if (pos != null) {
            this.x.setInput("" + pos.m_123341_());
            this.y.setInput("" + pos.m_123342_());
            this.z.setInput("" + pos.m_123343_());
            this.dim.setDimension(m.getWorld());
        }
    }

    public void setButton(Line text, int color, Runnable action) {
        this.setButton(new Space(64, 18, this.getWidth() - 64, 14), text, color, action);
    }

    public void setButton(Space space, Line text, int color, Runnable action) {
        this.select = new EyeButton(space.width, space.height, text);
        this.select.setText(text);
        this.select.setColor(color);
        this.select.setAction(action);
        this.add(this.select, space.x, space.y);
        if (space.y + space.height > this.getHeight()) {
            this.setHeight(space.y + space.height);
        }
    }

    public BlockPos getPos() {
        BlockPos u = Minecraft.m_91087_().f_91074_.m_20183_();
        String sx = this.x.getInput();
        String sy = this.y.getInput();
        String sz = this.z.getInput();
        return new BlockPos(this.getInt(sx, u.m_123341_()), this.getInt(sy, u.m_123342_()), this.getInt(sz, u.m_123343_()));
    }

    private int getInt(String s, int tilt) {
        Object object = s = ((String)s).isEmpty() || ((String)s).equals("") || !((String)s).matches("[0-9~-]+") ? "~" : s;
        if (((String)s).contains("-")) {
            s = "-" + ((String)s).replace("-", "");
        }
        if (((String)s).contains("~")) {
            String v = ((String)s).replace("~", "");
            return Integer.valueOf(v.equals("") ? "0" : v) + tilt;
        }
        return Integer.valueOf((String)s);
    }

    public ResourceLocation getWorld() {
        return this.dim.getDimension();
    }
}

