/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.presets;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.panes.ContactsPane;
import com.podloot.eyemod.gui.panes.PlayersPane;
import com.podloot.eyemod.gui.presets.PresetInput;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import java.util.List;
import net.minecraft.world.entity.player.Player;

public class PlayerPreset
extends PresetInput {
    public PlayerPreset(App app, int width) {
        super(app, width, 32, new Line("text.eyemod.player").setColor(-3223858).setStyle(false, true));
        this.name.setAllowed("[a-zA-Z0-9_]+");
        this.name.setSuggest(this.getPlayerNames());
        EyeButton contacts = new EyeButton(14, 14, EyeLib.CONTACTS);
        contacts.setHover(new Line("text.eyemod.hover_contacts"));
        EyeButton online = new EyeButton(14, 14, EyeLib.ONLINE);
        online.setColor(-3223858, -10896292);
        online.setHover(new Line("text.eyemod.hover_online"));
        contacts.setAction(() -> {
            ContactsPane con = new ContactsPane(app, app.getWidth() - 4, app.getHeight() - 22);
            con.addItems(app.getDevice().data.getList("contacts", Naming.Type.STRING));
            con.setAction(() -> {
                String data = (String)con.getData();
                if (data != null) {
                    this.name.setInput(data);
                }
            });
            app.openPane(con);
        });
        online.setAction(() -> {
            PlayersPane onl = new PlayersPane(app, app.getWidth() - 4, app.getHeight() - 22);
            onl.addItems(app.getDevice().getUser().f_19853_);
            onl.setAction(() -> {
                String data = (String)onl.getData();
                if (data != null) {
                    this.name.setInput(data);
                }
            });
            app.openPane(onl);
        });
        this.add(contacts, 0, 18);
        this.add(online, 16, 18);
    }

    public String[] getPlayerNames() {
        List pl = this.app.getDevice().getUser().f_19853_.m_6907_();
        String[] names = new String[pl.size()];
        for (int i = 0; i < pl.size(); ++i) {
            names[i] = ((Player)pl.get(i)).m_6302_();
        }
        return names;
    }
}

