/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.panes;

import com.podloot.eyemod.blocks.entities.RouterEntity;
import com.podloot.eyemod.gui.GuiDevice;
import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.panes.Pane;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Pos;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyePlane;
import com.podloot.eyemod.lib.gui.widgets.EyeTextField;
import com.podloot.eyemod.network.PacketHandler;
import com.podloot.eyemod.network.ServerRouter;
import com.podloot.eyemod.network.ServerRouterData;

public class RouterPane
extends Pane {
    public RouterPane(App app, int width, int height) {
        super(app, width, height);
        this.load();
        this.addAccept(0);
    }

    public boolean load() {
        GuiDevice device = this.app.getDevice();
        boolean connected = device.connect.isConnected();
        Pos router = device.connect.getRouter();
        boolean hasRouter = device.connect.isRouter(router);
        RouterEntity be = device.connect.getRouterData();
        if (!connected || be == null || !hasRouter) {
            EyeLabel status = new EyeLabel(this.getWidth() - 4, 14, new Line("text.eyemod.net_noconnection"));
            status.setBack(this.app.appColor);
            status.setAlignment(1, 0);
            this.add(status, 2, 2);
            return true;
        }
        String owner = be.owner;
        String password = be.password;
        boolean isOwner = device.getUser().m_6302_().equals(owner);
        EyeLabel status = new EyeLabel(this.getWidth() - 4, 14, new Line("text.eyemod.net_status"));
        status.setBack(this.app.appColor);
        status.setAlignment(1, 0);
        this.add(status, 2, 2);
        EyePlane background = new EyePlane(this.getWidth() - 4, 66, -3223858);
        this.add(background, 2, 18);
        EyeLabel con = new EyeLabel(this.getWidth() - 4, 14, new Line("text.eyemod.net_connection"));
        con.setAlignment(1, 0);
        con.setVariable((String)(connected ? device.connect.getConnection() + "/3" : "NA"));
        EyeLabel rout = new EyeLabel(this.getWidth() - 4, 14, new Line("text.eyemod.net_router"));
        rout.setAlignment(1, 0);
        rout.setVariable(hasRouter ? router.asString(false) : "NA");
        EyeLabel stor = new EyeLabel(this.getWidth() - 4, 14, new Line("text.eyemod.net_storage"));
        stor.setAlignment(1, 0);
        stor.setVariable(be.storage + be.messages.size() + "/" + be.max_storage * 2 + "GB");
        EyeLabel own = new EyeLabel(this.getWidth() - 4, 14, new Line("text.eyemod.net_owner"));
        own.setAlignment(1, 0);
        own.setVariable(owner.isEmpty() ? "NA" : owner);
        EyeLabel pass = new EyeLabel(this.getWidth() - 4, 14, new Line("text.eyemod.net_password"));
        pass.setAlignment(1, 0);
        if (password.isEmpty()) {
            pass.setVariable("NA");
        } else {
            pass.setVariable(isOwner ? password : "*****");
        }
        this.add(con, 6, 20);
        this.add(rout, 6, 32);
        this.add(stor, 6, 44);
        this.add(own, 6, 56);
        this.add(pass, 6, 68);
        if (owner.equals(device.getOwner())) {
            EyeLabel change = new EyeLabel(this.getWidth() - 4, 16, new Line("text.eyemod.net_change"));
            change.setBack(-3223858);
            this.add(change, 2, this.getHeight() - 72);
            EyeTextField pw = new EyeTextField(this.getWidth() - 48, 16);
            pw.setLimit(16);
            pw.setText(new Line("text.eyemod.settings_password"));
            EyeButton setpw = new EyeButton(42, 16, new Line("text.eyemod.change"));
            setpw.setAction(() -> {
                if (isOwner) {
                    PacketHandler.INSTANCE.sendToServer((Object)new ServerRouter(router, Naming.Action.SET_PASSWORD, pw.getInput()));
                }
            });
            this.add(pw, 2, this.getHeight() - 54);
            this.add(setpw, this.getWidth() - 44, this.getHeight() - 54);
            EyeButton clear = new EyeButton(this.getWidth() - 4, 16, new Line("text.eyemod.net_clear"));
            clear.setColor(-292985);
            clear.setAction(() -> {
                if (isOwner) {
                    PacketHandler.INSTANCE.sendToServer((Object)new ServerRouterData(router, Naming.Action.RESET, "", null));
                }
            });
            this.add(clear, 2, this.getHeight() - 36);
        }
        return true;
    }
}

