/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.panes;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.panes.Pane;
import com.podloot.eyemod.lib.gui.widgets.EyePlane;
import com.podloot.eyemod.lib.gui.widgets.EyeSlider;
import java.awt.Color;

public class ColorPane
extends Pane {
    EyeSlider red;
    EyeSlider green;
    EyeSlider blue;
    EyePlane color;

    public ColorPane(App app, int width, int height) {
        super(app, width, height);
        this.red = new EyeSlider(width - 8, 12, 0, 255);
        this.red.setColor(-65536);
        this.green = new EyeSlider(width - 8, 12, 0, 255);
        this.green.setColor(-16711936);
        this.blue = new EyeSlider(width - 8, 12, 0, 255);
        this.blue.setColor(-16776961);
        this.add(this.red, 4, 4);
        this.add(this.green, 4, 20);
        this.add(this.blue, 4, 36);
        this.color = new EyePlane(width - 42, 12, -1);
        this.add(this.color, 4, height - 16);
        this.addAccept(0);
        this.addCancel(1);
    }

    public void setValue(int color) {
        Color c = new Color(color);
        this.red.setState(c.getRed());
        this.green.setState(c.getGreen());
        this.blue.setState(c.getBlue());
    }

    @Override
    public void tick(int mx, int my) {
        Color c = new Color(this.red.getValue(), this.green.getValue(), this.blue.getValue());
        this.color.setColor(c.getRGB());
        super.tick(mx, my);
    }

    public int getColor() {
        return new Color(this.red.getValue(), this.green.getValue(), this.blue.getValue()).getRGB();
    }
}

