/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.panes;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.panes.Pane;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeIcon;
import com.podloot.eyemod.lib.gui.widgets.EyeList;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class AppPane
extends Pane {
    EyeList appSettings;
    int refresh = 0;

    public AppPane(App app, int width, int height) {
        super(app, width, height);
        this.load();
    }

    public void load() {
        this.appSettings = new EyeList(this.getWidth() - 4, this.getHeight() - 20, EyeWidget.Axis.VERTICAL);
        this.add(this.appSettings, 2, 2);
        for (App a : this.app.getDevice().getInstalledApps()) {
            this.appSettings.add(this.getAppPanel(a));
        }
        this.addAccept(0);
    }

    public EyePanel getAppPanel(App app) {
        EyePanel panel = new EyePanel(this.getWidth() - 14, 40);
        EyeIcon icon = new EyeIcon(32, 32, app.appIcon);
        icon.setBack(app.getAppColor());
        EyeButton up = new EyeButton(14, 14, EyeLib.UP);
        up.setAction(() -> this.move(app, -1));
        EyeButton down = new EyeButton(14, 14, EyeLib.DOWN);
        down.setAction(() -> this.move(app, 1));
        EyeButton clear = new EyeButton(this.getWidth() - 14 - 50, 14, new Line("text.eyemod.settings_clearapp"));
        clear.setAction(() -> app.onClearData());
        clear.setEnabled(app.hasData());
        panel.add(clear, 50, 0);
        EyeButton remove = new EyeButton(this.getWidth() - 14 - 50, 14, new Line("text.eyemod.settings_deinstall"));
        remove.setColor(-292985);
        remove.setAction(() -> {
            if (app.hasData()) {
                app.onClearData();
            }
            app.getDevice().deinstallApp(app);
            this.refresh = 2;
        });
        panel.add(remove, 50, 18);
        panel.add(up, 0, 0);
        panel.add(down, 0, 18);
        panel.add(icon, 16, 0);
        return panel;
    }

    public ListTag move(App app, int move) {
        ListTag apps = this.app.getDevice().data.getList("apps", Naming.Type.STRING);
        StringTag s = StringTag.m_129297_((String)app.getId().toString());
        int i = apps.indexOf((Object)s) + move;
        apps.remove((Object)s);
        int np = i < 0 ? 0 : (i > apps.size() ? apps.size() : i);
        apps.add(np, (Tag)s);
        this.app.getDevice().data.setList("apps", apps);
        this.appSettings.updateItems();
        this.refresh = 2;
        return apps;
    }

    public void refreshList() {
        int scroll = this.appSettings.getScroll();
        this.clear();
        this.load();
        this.appSettings.setScroll(scroll);
    }

    @Override
    public void tick(int mx, int my) {
        if (this.refresh > 0) {
            if (this.refresh == 1) {
                this.refreshList();
            }
            --this.refresh;
        }
        super.tick(mx, my);
    }
}

