/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.elements.map;

import com.mojang.blaze3d.platform.NativeImage;
import com.podloot.eyemod.lib.gui.util.Color;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MaterialColor;

public class MapType {
    Level world;
    BlockPos mapPos;
    int bottom = 0;
    int height = 0;
    int light_min = 50;
    int light_max = 20;
    HashMap<Block, MaterialColor> recolor = new HashMap();
    int[] tr = new int[]{0, 0, 0, 110, 20, 0};
    int[] tg = new int[]{0, 0, 30, 20, 20, 0};
    int[] tb = new int[]{0, 0, 100, -10, 30, 0};

    public MapType(Level world) {
        this.world = world;
        this.bottom = world.m_141937_();
        this.height = world.m_151558_();
        this.recolor.put(Blocks.f_50359_, Blocks.f_50440_.m_60590_());
        this.recolor.put(Blocks.f_50034_, Blocks.f_50440_.m_60590_());
    }

    public MapType set(BlockPos mapPos) {
        this.mapPos = mapPos;
        return this;
    }

    public void setRange(int bottom, int height, int lmin, int lmax) {
        this.bottom = bottom;
        this.height = height;
        this.light_min = lmin;
        this.light_max = lmax;
        System.out.println(Blocks.f_50126_.m_60590_().f_76396_);
    }

    public DynamicTexture getMap(int width, int height) {
        NativeImage map = new NativeImage(width, height, false);
        if (this.mapPos == null) {
            return new DynamicTexture(map);
        }
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int x = this.mapPos.m_123341_() - width / 2;
                int z = this.mapPos.m_123343_() - height / 2;
                map.m_84988_(i, j, this.getMapColor(x + i, z + j));
            }
        }
        return new DynamicTexture(map);
    }

    public int getMapColor(int x, int z) {
        int trans = 0;
        for (int i = this.height; i >= this.bottom; --i) {
            BlockState bs = this.world.m_8055_(new BlockPos(x, i, z));
            int t = this.isTransperant(bs);
            if (t == 0) {
                float grey = this.getDarkness(this.mapPos.m_123342_() - this.light_min, this.mapPos.m_123342_() + this.light_max, i);
                Color co = new Color(this.getColor(bs));
                int e = i % 2 == 0 ? 8 : 0;
                int b = (int)((float)co.getBlue() * grey) + e + this.tb[trans];
                int g = (int)((float)co.getGreen() * grey) + e + this.tg[trans];
                int r = (int)((float)co.getRed() * grey) + e + this.tr[trans];
                return new Color(r < 0 ? 0 : (r > 255 ? 255 : r), g < 0 ? 0 : (g > 255 ? 255 : g), b < 0 ? 0 : (b > 255 ? 255 : b)).getBGR();
            }
            if (t <= 1) continue;
            trans = t;
        }
        return -16777216;
    }

    public int isTransperant(BlockState bs) {
        if (bs.m_60795_()) {
            return 1;
        }
        if (!bs.m_60819_().m_76178_()) {
            if (bs.m_60734_() == Blocks.f_49991_) {
                return 3;
            }
            return 2;
        }
        if (bs.m_60734_() == Blocks.f_50058_ || bs.m_60734_() instanceof CrossCollisionBlock) {
            return 4;
        }
        return 0;
    }

    public int getColor(BlockState bs) {
        if (this.recolor.containsKey(bs.m_60734_())) {
            return this.recolor.get((Object)bs.m_60734_()).f_76396_;
        }
        MaterialColor mc = bs.m_60734_().m_60590_();
        return mc == MaterialColor.f_76398_ ? Blocks.f_50011_.m_60590_().f_76396_ : mc.f_76396_;
    }

    public int getHeight(int x, int z) {
        for (int i = this.height; i >= this.bottom; --i) {
            BlockState bs = this.world.m_8055_(new BlockPos(x, i, z));
            if (bs.m_60795_()) continue;
            return i;
        }
        return 0;
    }

    public float getDarkness(int min, int max, int value) {
        value = value < min ? min : (value > max ? max : value);
        return (float)(value - min) / (float)(max - min) * 0.9f + 0.1f;
    }

    public ResourceLocation getWorldID() {
        return this.world.m_46472_().m_135782_();
    }

    public Level getWorld() {
        return this.world;
    }
}

