/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.elements.map;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.util.Image;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import net.minecraft.core.BlockPos;

public class MapItem
extends EyeWidget {
    BlockPos pos;
    String name;
    int rotation = 180;
    Image icon;
    int color;
    int off = 0;
    float ps = 0.0f;

    public MapItem(Image icon, BlockPos pos, int color) {
        super(false, 8, 8);
        this.icon = icon;
        this.pos = pos;
        this.color = color;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        matrices.m_85836_();
        matrices.m_85837_((double)x, (double)(y - this.off), 0.0);
        matrices.m_85837_((double)this.ps, (double)this.ps, 0.0);
        matrices.m_85845_(Vector3f.f_122227_.m_122240_((float)(this.rotation + 180)));
        matrices.m_85837_((double)(-this.icon.width / 2), (double)(-this.icon.height / 2), 0.0);
        EyeDraw.texture(matrices, this.icon, 0, 0, 12, 12, this.color);
        matrices.m_85849_();
        if (this.name != null && !this.name.isEmpty()) {
            EyeDraw.text(matrices, new Line(this.name).setScale(0.6f), (int)((float)(x + 2) + this.ps), (int)((float)(y + 4) + this.ps));
        }
    }

    public void updatePos(int width, int height, int mapSize, BlockPos mapPos, float ps) {
        float nx = (float)width / (float)mapSize * ((float)(this.pos.m_123341_() - mapPos.m_123341_()) + (float)mapSize / 2.0f);
        float nz = (float)height / (float)mapSize * ((float)(this.pos.m_123343_() - mapPos.m_123343_()) + (float)mapSize / 2.0f);
        this.setPos((int)nx, (int)nz);
        this.ps = ps;
    }

    public void setBlockPos(BlockPos pos) {
        this.pos = pos;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

