/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.elements.map;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.gui.elements.map.Map;
import com.podloot.eyemod.gui.elements.map.MapItem;
import com.podloot.eyemod.gui.elements.map.MapType;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;

public class MapContent
extends EyePanel {
    int zoom = 0;
    int w;
    int h;
    Map map;
    BlockPos mapPos;
    DynamicTexture content;
    MapType type;
    MapItem selected;
    float ps = 0.5f;
    int mapSize = 64;
    int max = 2560;

    public MapContent(Map map, int width, int height, int mapSize, BlockPos mapPos, MapType type) {
        super(width, height);
        this.w = width;
        this.h = height;
        this.map = map;
        this.mapSize = mapSize;
        this.mapPos = mapPos;
        this.type = type;
        this.setMap();
        this.selected = new MapItem(EyeLib.MAP_SELECTED, mapPos, -292985);
        this.selected.setRotation(45);
        this.selected.hide(true);
        this.addItem(this.selected);
    }

    public void refresh(BlockPos mapPos) {
        this.type.set(mapPos);
        this.mapPos = mapPos;
        this.setMap();
    }

    public void refresh(BlockPos mapPos, MapType type) {
        this.type = type.set(mapPos);
        this.mapPos = mapPos;
        this.setMap();
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        if (this.content != null) {
            RenderSystem.m_157453_((int)0, (int)this.content.m_117963_());
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            GuiComponent.m_93160_((PoseStack)matrices, (int)x, (int)y, (int)this.getWidth(), (int)this.getHeight(), (float)0.0f, (float)0.0f, (int)this.mapSize, (int)this.mapSize, (int)this.mapSize, (int)this.mapSize);
            RenderSystem.m_69461_();
        }
        super.draw(matrices, x, y);
    }

    @Override
    public void tick(int mx, int my) {
        this.updateItems();
        super.tick(mx, my);
    }

    public void setMap() {
        this.content = this.type.getMap(this.mapSize, this.mapSize);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        int pw = this.getWidth();
        int ph = this.getHeight();
        double d = amount * 32.0 * (double)Math.max(this.ps, 0.5f);
        int nw = (int)((double)this.getWidth() + d);
        int nh = (int)((double)this.getHeight() + d);
        int min = Math.max(this.map.getWidth(), this.map.getHeight());
        int n = nw < min ? min : (nw = nw > this.max ? this.max : nw);
        nh = nh < min ? min : (nh > this.max ? this.max : nh);
        this.setSize(nw, nh);
        this.ps = (float)(this.getWidth() / this.mapSize) / 2.0f;
        this.map.setScroll(EyeWidget.Axis.HORIZONTAL, this.map.getScroll_x() + (nw - pw) / 2);
        this.map.setScroll(EyeWidget.Axis.VERTICAL, this.map.getScroll_y() + (nh - ph) / 2);
        return true;
    }

    public void updateItems() {
        for (EyeWidget w : this.widgets) {
            if (!(w instanceof MapItem)) continue;
            ((MapItem)w).updatePos(this.getWidth(), this.getHeight(), this.mapSize, this.mapPos, this.ps);
        }
    }

    @Override
    public void close() {
        if (this.content != null) {
            this.content.close();
        }
        super.close();
    }

    public void addItem(MapItem icon) {
        this.add(icon, 0, 0);
        BlockPos pos = icon.getPos();
        float nx = (float)this.getWidth() / (float)this.mapSize * ((float)(pos.m_123341_() - this.mapPos.m_123341_()) + (float)this.mapSize / 2.0f);
        float nz = (float)this.getHeight() / (float)this.mapSize * ((float)(pos.m_123343_() - this.mapPos.m_123343_()) + (float)this.mapSize / 2.0f);
        icon.setPos((int)nx, (int)nz);
    }

    public BlockPos getBlockPos(double mouseX, double mouseY) {
        double px = (double)((float)this.mapSize / (float)this.getWidth()) * mouseX;
        double pz = (double)((float)this.mapSize / (float)this.getHeight()) * mouseY;
        int x = (int)(px + (double)this.mapPos.m_123341_() - (double)(this.mapSize / 2));
        int z = (int)(pz + (double)this.mapPos.m_123343_() - (double)(this.mapSize / 2));
        return new BlockPos(x -= x < 0 ? 1 : 0, this.type.getHeight(x, z -= z < 0 ? 1 : 0), z);
    }

    public BlockPos getMapPos() {
        return this.mapPos;
    }
}

