/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.elements.map;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.gui.elements.map.MapContent;
import com.podloot.eyemod.gui.elements.map.MapEntity;
import com.podloot.eyemod.gui.elements.map.MapItem;
import com.podloot.eyemod.gui.elements.map.MapType;
import com.podloot.eyemod.gui.elements.map.MapTypeOverworld;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyeScrollPanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Pos;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class Map
extends EyeScrollPanel {
    MapContent content;
    boolean dragging;
    double last_x;
    double last_y;
    double drag_x;
    double drag_y;
    boolean showSelectedPos = true;

    public Map(int width, int height, int mapSize, BlockPos mapPos, MapType type) {
        super(width, height);
        type.set(mapPos);
        this.load(mapSize, mapPos, type);
    }

    public Map(int width, int height, int mapSize, BlockPos mapPos, Level world) {
        super(width, height);
        MapType type = new MapType(world).set(mapPos);
        ResourceLocation wid = world.m_46472_().m_135782_();
        if (wid.equals((Object)Naming.Dim.OVERWORLD.id)) {
            type = new MapTypeOverworld(world).set(mapPos);
        }
        if (wid.equals((Object)Naming.Dim.NETHER.id)) {
            type.setRange(world.m_141937_(), mapPos.m_123342_() + 2, 70, 20);
        }
        if (wid.equals((Object)Naming.Dim.END.id)) {
            type.setRange(world.m_151558_(), mapPos.m_123342_() + 40, 40, 40);
        }
        this.load(mapSize, mapPos, type);
    }

    public void load(int mapSize, BlockPos mapPos, MapType type) {
        int min = Math.max(this.getWidth(), this.getHeight());
        this.content = new MapContent(this, Math.max(mapSize, min), Math.max(mapSize, min), mapSize, mapPos, type);
        this.add(this.content, 0, 0);
        this.setScroll(EyeWidget.Axis.HORIZONTAL, this.content.getWidth() / 2 - this.getWidth() / 2);
        this.setScroll(EyeWidget.Axis.VERTICAL, this.content.getWidth() / 2 - this.getHeight() / 2);
    }

    public void addPlayer(Player player) {
        MapEntity icon = new MapEntity(EyeLib.MAP_PLAYER, (Entity)player, -1);
        this.content.addItem(icon);
    }

    public void addPlayers() {
        for (Player point : Minecraft.m_91087_().f_91073_.m_6907_()) {
            if (point.m_7755_().equals(Minecraft.m_91087_().f_91074_.m_7755_())) continue;
            MapEntity icon = new MapEntity(EyeLib.MAP_PLAYER, (Entity)Minecraft.m_91087_().f_91073_.m_46003_(point.m_20148_()), -6710887);
            icon.setName(point.m_6302_());
            this.content.addItem(icon);
        }
    }

    public void addWaypoints(ListTag points) {
        for (int i = 0; i < points.size(); ++i) {
            Pos pos = new Pos().fromString(points.m_128778_(i));
            if (!pos.getWorld().equals((Object)this.content.type.getWorldID()) || pos.getPos().m_123333_((Vec3i)this.content.mapPos) >= this.content.mapSize * 2) continue;
            MapItem waypoint = new MapItem(EyeLib.MAP_LOCATION, pos.getPos(), -1);
            waypoint.off = 4;
            waypoint.setName(pos.getName());
            this.content.addItem(waypoint);
        }
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        BlockPos selected;
        EyeDraw.rect(matrices, x, y, this.getWidth(), this.getHeight(), -16777216);
        super.draw(matrices, x, y);
        if (this.showSelectedPos && this.content.selected != null && (selected = this.content.selected.pos) != null) {
            EyeDraw.text(matrices, new Line(selected.m_123341_() + "/" + selected.m_123342_() + "/" + selected.m_123343_()).setScale(0.75f), x + this.getWidth() / 2, y + 6);
        }
        EyeDraw.nine(matrices, EyeLib.MAP_BORDER, x, y, this.getWidth(), this.getHeight(), -1);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        return this.content.mouseScrolled(mouseX, mouseY, amount);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.dragging = true;
        this.last_x = mouseX;
        this.last_y = mouseY;
        this.drag_x = mouseX;
        this.drag_y = mouseY;
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.isDragged(4)) {
            this.content.selected.hide(false);
            this.content.selected.setBlockPos(this.content.getBlockPos(mouseX - (double)this.content.getGlobalX(), mouseY - (double)this.content.getGlobalY()));
            this.content.selected.updatePos(this.getWidth(), this.getHeight(), this.content.mapSize, this.content.mapPos, this.content.ps);
        }
        this.dragging = false;
        return true;
    }

    @Override
    public void tick(int mx, int my) {
        if (this.dragging) {
            this.setScroll(EyeWidget.Axis.HORIZONTAL, (int)((double)this.getScroll_x() + (this.drag_x - (double)mx)));
            this.setScroll(EyeWidget.Axis.VERTICAL, (int)((double)this.getScroll_y() + (this.drag_y - (double)my)));
            this.drag_x = mx;
            this.drag_y = my;
        }
        super.tick(mx, my);
    }

    public boolean isDragged(int distance) {
        if (Math.abs(this.drag_x - this.last_x) < (double)distance && Math.abs(this.drag_y - this.last_y) < (double)distance) {
            return false;
        }
        return this.dragging;
    }

    public MapContent getContent() {
        return this.content;
    }

    public BlockPos getSelected() {
        if (this.content == null || this.content.selected == null) {
            return null;
        }
        return this.content.selected.pos;
    }

    public ResourceLocation getWorld() {
        return this.content.type.world.m_46472_().m_135782_();
    }
}

