/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.gui.GuiDevice;
import com.podloot.eyemod.gui.elements.DeviceButton;
import com.podloot.eyemod.gui.util.Time;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeIcon;
import com.podloot.eyemod.lib.gui.widgets.EyeState;

public class StatusBar
extends EyePanel {
    GuiDevice device;
    EyeState wifi;
    EyeState reach;
    EyeState battery;

    public StatusBar(GuiDevice device, int width, int height) {
        super(width, height);
        this.device = device;
        EyeIcon logo = new EyeIcon(8, 8, EyeLib.EYE);
        this.add(logo, 1, 0);
        this.wifi = new EyeState(8, 8, EyeLib.CONNECTION, 4);
        int connect = device.connect.getConnection();
        this.wifi.setState(connect);
        this.add(this.wifi, 16, 0);
        this.reach = new EyeState(5, 8, EyeLib.COVERAGE, 4);
        this.reach.setState(device.connect.getReach());
        this.add(this.reach, 10, 0);
        this.battery = new EyeState(10, 8, EyeLib.BATTERY, 8);
        this.add(this.battery, width - 11, 0);
        DeviceButton console = new DeviceButton(8, 8, EyeLib.CONSOLE);
        console.setAction(() -> {
            if (!device.isLocked()) {
                device.openConsole();
            }
        });
        this.add(console, width - 21, 0);
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        EyeDraw.rect(matrices, x, y, this.getWidth(), this.getHeight(), 0x55000000);
        EyeDraw.text(matrices, new Line(Time.getTime()).setScale(0.8f), x + this.getWidth() / 2, y + this.getHeight() / 2);
        super.draw(matrices, x, y);
    }

    @Override
    public void tick(int mx, int my) {
        int dmg = this.device.getItem().m_41773_();
        int max = this.device.getItem().m_41776_();
        int state = dmg / (max / 8);
        this.battery.setState(7 - state);
        int connect = this.device.connect.getConnection();
        this.wifi.setState(connect);
        super.tick(mx, my);
    }
}

