/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Image;
import com.podloot.eyemod.lib.gui.widgets.EyeClickable;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class DimensionButton
extends EyeClickable {
    ResourceLocation dimension;
    HashMap<ResourceLocation, Image> dimensions;

    public DimensionButton(int width, int height, ResourceLocation dim) {
        super(width, height);
        this.dimension = Naming.Dim.OVERWORLD.id;
        this.dimensions = new HashMap();
        this.setColor(-1);
        this.dimension = dim;
        this.dimensions.put(Naming.Dim.OVERWORLD.id, EyeLib.OVERWOLD);
        this.dimensions.put(Naming.Dim.NETHER.id, EyeLib.THE_NETHER);
        this.dimensions.put(Naming.Dim.END.id, EyeLib.THE_END);
        this.setAction(() -> {
            this.dimension = this.dimension == Naming.Dim.OVERWORLD.id ? Naming.Dim.NETHER.id : (this.dimension == Naming.Dim.NETHER.id ? Naming.Dim.END.id : (this.dimension == Naming.Dim.END.id ? Naming.Dim.OVERWORLD.id : Naming.Dim.OVERWORLD.id));
        });
    }

    public DimensionButton(int width, int height, Level world) {
        this(width, height, world.m_46472_().m_135782_());
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public void setDimension(ResourceLocation world) {
        this.dimension = world;
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        EyeDraw.texture(matrices, this.getIcon(), x, y, this.getWidth(), this.getHeight(), this.getPrimary());
        EyeDraw.nine(matrices, EyeLib.PLANE_BORDER, x, y, this.getWidth(), this.getHeight(), this.isHovered() ? -1 : -16777216);
    }

    private Image getIcon() {
        if (this.dimensions.containsKey(this.dimension)) {
            return this.dimensions.get(this.dimension);
        }
        return EyeLib.DIMENSION;
    }
}

