/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.elements;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.gui.util.Photos;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class Background
extends EyeWidget {
    boolean isImage = false;
    int backColor = -3223858;
    String backImage = "";
    DynamicTexture image;

    public Background(int width, int height, Tag background) {
        super(false, width, height);
        if (background != null && background.m_7060_() == Naming.Type.INT.type) {
            this.backColor = ((IntTag)background).m_7047_();
            this.isImage = false;
        } else if (background != null && background.m_7060_() == Naming.Type.STRING.type) {
            this.backImage = ((StringTag)background).m_7916_();
            NativeImage img = Photos.readShot(this.backImage);
            if (img != null) {
                this.image = new DynamicTexture(img);
                img.close();
            }
            this.isImage = true;
        }
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        if (!this.isImage) {
            EyeDraw.rect(matrices, x, y, this.getWidth(), this.getHeight(), this.backColor);
        } else if (this.image != null) {
            EyeDraw.texture(matrices, this.image, x, y, this.getWidth(), this.getHeight());
        } else {
            EyeDraw.texture(matrices, EyeLib.DEFAULT, x, y, this.getWidth(), this.getHeight(), -3223858);
        }
    }

    @Override
    public void close() {
        if (this.image != null) {
            this.image.close();
        }
        super.close();
    }
}

