/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Image;
import com.podloot.eyemod.lib.gui.widgets.EyeClickable;

public class AppButton
extends EyeClickable {
    Image icon;
    boolean notification;

    public AppButton(App app) {
        super(32, 32);
        this.icon = app.appIcon;
        this.setColor(app.getAppColor());
        this.setText(app.getName().setAllingment(0, 1).setScale(0.8f));
        if (app.getDevice() != null) {
            this.notification = !app.getDevice().getNotifications(app.getId()).isEmpty();
        }
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        EyeDraw.nine(matrices, EyeLib.PLANE, x, y, this.getWidth(), this.getHeight(), this.getPrimary());
        EyeDraw.nine(matrices, EyeLib.PLANE_BORDER, x, y, this.getWidth(), this.getHeight(), this.isHovered() ? -1 : -16777216);
        if (this.icon != null) {
            EyeDraw.texture(matrices, this.icon, x, y, this.getWidth(), this.getHeight(), -1);
        }
        if (this.getText() != null) {
            EyeDraw.text(matrices, this.getText(), x + this.getWidth() / 2, y + this.getHeight() + 1);
        }
        if (this.notification) {
            EyeDraw.texture(matrices, EyeLib.NOTIFICATION, x + this.getWidth() - 9, y - 3, 12, 12);
        }
    }
}

