/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.stock;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.panes.ConfirmPane;
import com.podloot.eyemod.gui.panes.StorePane;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeIcon;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeList;
import com.podloot.eyemod.lib.gui.widgets.EyeText;
import com.podloot.eyemod.lib.gui.widgets.EyeVariable;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class AppStore
extends App {
    EyeList store;

    public AppStore() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appstore.png"), -6767105, "Eye");
    }

    @Override
    public boolean load() {
        this.store = new EyeList(this.getWidth() - 4, this.getHeight() - 22, EyeWidget.Axis.VERTICAL);
        this.add(this.store, 2, 2);
        List<App> installed = this.device.getInstalledApps();
        for (App a : this.device.loaded_apps.values()) {
            if (installed.contains(a)) continue;
            this.store.add(this.getAppPanel(a, this.getWidth() - 14));
        }
        if (this.store.sizeList() <= 0) {
            EyeText out = new EyeText(this.getWidth() - 14, 8, new Line("text.eyemod.store_out"));
            out.setAlignment(1, 1);
            out.setBack(this.getAppColor());
            this.store.add(out);
        }
        EyeVariable money = new EyeVariable(this.getWidth() / 2 - 8, 16, new Line("text.eyemod.store_price"));
        money.setBack(-12303292);
        money.setVariable(() -> "" + this.device.data.getInt("money"));
        this.add(money, 2, this.getHeight() - 18);
        EyeButton apps = new EyeButton(this.getWidth() / 2 - 4, 16, new Line("text.eyemod.store_apps"));
        apps.setColor(this.getAppColor());
        apps.setAction(() -> {
            StorePane pane = new StorePane(this, this.getWidth() - 8, this.getHeight() - 8);
            this.openPane(pane);
            pane.setAction(() -> this.refresh());
        });
        this.add(apps, this.getWidth() / 2 + 2, this.getHeight() - 18);
        return false;
    }

    public EyePanel getAppPanel(App app, int w) {
        EyePanel panel = new EyePanel(w, 90);
        panel.setBack(this.getAppColor());
        EyeIcon icon = new EyeIcon(32, 32, app.appIcon);
        icon.setBack(app.appColor);
        EyeLabel name = new EyeLabel(w - 42, 16, app.getName());
        name.setAlignment(1, 0);
        name.setBack(app.getAppColor());
        EyeLabel creator = new EyeLabel(w - 42, 14, new Line(app.getCreator()));
        creator.setAlignment(1, 0);
        creator.setBack(app.getAppColor());
        EyeText desc = new EyeText(w - 8, 32, app.getDescription());
        desc.setAlignment(0, 0);
        desc.setBack(app.appColor);
        EyeLabel price = new EyeLabel(42, 14, new Line("text.eyemod.store_price"));
        price.setBack(-3223858);
        price.setVariable("" + app.getPrice());
        price.setAlignment(1, 0);
        EyeButton buy = new EyeButton(w - 52, 14, new Line("text.eyemod.buy"));
        buy.setColor(-7219576);
        buy.setAction(() -> {
            if (this.buy(app)) {
                this.store.delete(panel);
                this.device.connect.sendMail(this.getCreator(), "Purchase", "Dear " + this.device.getOwner() + ", | Thank you for your purchase at the EyeStore! | | App: " + app.getName().getText() + " | Price: $" + app.getPrice());
            }
        });
        panel.add(icon, 4, 4);
        panel.add(name, 38, 4);
        panel.add(creator, 38, 22);
        panel.add(desc, 4, 38);
        panel.add(price, 4, 72);
        panel.add(buy, 48, 72);
        return panel;
    }

    public boolean buy(App app) {
        boolean ins = this.device.installApp(app);
        if (ins) {
            ConfirmPane con = new ConfirmPane(this, this.getWidth() - 8, 52, new Line("text.eyemod.store_bought"), false);
            this.openPane(con);
            con.setAction(() -> this.refresh());
            return true;
        }
        ConfirmPane mon = new ConfirmPane(this, this.getWidth() - 8, 52, new Line("text.eyemod.store_money"), false);
        this.openPane(mon);
        return false;
    }

    @Override
    public void onRefresh() {
        int scroll = this.store.getScroll();
        super.onRefresh();
        if (this.store != null) {
            this.store.setScroll(scroll);
        }
    }
}

