/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.stock;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.panes.AppPane;
import com.podloot.eyemod.gui.panes.ColorPane;
import com.podloot.eyemod.gui.panes.ConfirmPane;
import com.podloot.eyemod.gui.panes.PhotoPane;
import com.podloot.eyemod.gui.panes.RouterPane;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.gui.util.NbtManager;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeItem;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeList;
import com.podloot.eyemod.lib.gui.widgets.EyeProcess;
import com.podloot.eyemod.lib.gui.widgets.EyeTextField;
import com.podloot.eyemod.lib.gui.widgets.EyeToggle;
import com.podloot.eyemod.lib.gui.widgets.EyeVariable;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class AppSettings
extends App {
    EyeList settings;
    EyeProcess battery;
    int lastScroll = 0;
    private int[] border = new int[]{-14540254, -1, -4154220, -14275764, -447444, 0};
    private int[] back = new int[]{-13092808, -3223858, -2048072, -8748119, -2325115, 0};

    public AppSettings() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appsettings.png"), -3223858, "Eye");
        this.setColor(-14540254, -10066330);
    }

    @Override
    public void open() {
        this.device.settings.initSettings(this.device.data.getList("apps", Naming.Type.STRING), this.getSettingsWidth());
        super.open();
    }

    @Override
    public boolean load() {
        this.loadSettings();
        return true;
    }

    public void loadSettings() {
        this.settings = new EyeList(this.getWidth() - 4, this.getHeight() - 4, EyeWidget.Axis.VERTICAL);
        this.add(this.settings, 2, 2);
        EyeLabel general = new EyeLabel(this.getWidth(), 16, new Line("text.eyemod.settings_device").setStyle(true, true));
        general.setBack(this.getPrimary());
        this.settings.add(general);
        for (EyeWidget w : this.getDeviceSettings(this.getSettingsWidth())) {
            this.settings.add(w);
        }
        EyePanel space = new EyePanel(this.getWidth(), 16);
        this.settings.add(space);
        EyeLabel apps = new EyeLabel(this.getWidth(), 16, new Line("text.eyemod.settings_apps").setStyle(true, true));
        apps.setBack(this.getPrimary());
        this.settings.add(apps);
        for (List<EyeWidget> w : this.device.settings.app_settings.values()) {
            for (EyeWidget p : w) {
                this.settings.add(p);
            }
        }
    }

    public List<EyeWidget> getDeviceSettings(int width) {
        ArrayList<EyeWidget> set = new ArrayList<EyeWidget>();
        this.general(set, width);
        this.account(set, width);
        this.customization(set, width);
        this.privacy(set, width);
        this.eyenet(set, width);
        return set;
    }

    private void general(List<EyeWidget> set, int width) {
        EyeLabel gen = new EyeLabel(width, 16, new Line("text.eyemod.settings_general"));
        gen.setBack(this.getSecondary());
        set.add(gen);
        this.battery = new EyeProcess(width, 16, this.device.getItem().m_41776_());
        this.battery.setText(new Line("text.eyemod.settings_battery"), true);
        this.battery.setColor(-12303292, -10896292);
        set.add(this.battery);
        EyeProcess storage = new EyeProcess(width, 16, this.device.data.getInt("storage"));
        storage.setColor(-12303292, -13421773);
        storage.setText(new Line("text.eyemod.settings_storage"), true);
        storage.setState(NbtManager.getStorage(this.device.data.getNbt()));
        set.add(storage);
        EyeButton appMan = new EyeButton(width, 16);
        appMan.setText(new Line("text.eyemod.settings_appman"));
        appMan.setAction(() -> {
            AppPane ap = new AppPane(this, width, this.getHeight() - 8);
            this.openPane(ap);
        });
        set.add(appMan);
        EyeButton reset = new EyeButton(width, 16);
        reset.setText(new Line("text.eyemod.settings_cleardevice"));
        reset.setColor(-292985);
        reset.setAction(() -> {
            ConfirmPane con = new ConfirmPane(this, width, 52, new Line("text.eyemod.settings_clearconfirm"), true);
            con.setAction(() -> {
                this.device.clearAll();
                this.device.closeDevice();
            });
            this.openPane(con);
        });
        set.add(reset);
    }

    private void account(List<EyeWidget> set, int width) {
        EyeLabel gen = new EyeLabel(width, 16, new Line("text.eyemod.settings_account"));
        gen.setBack(this.getSecondary());
        set.add(gen);
        EyePanel panel = new EyePanel(width, 28);
        EyeVariable var = new EyeVariable(width, 10, new Line("text.eyemod.settings_money"));
        var.setVariable(() -> "" + this.device.data.getInt("money"));
        var.setAlignment(1, 0);
        panel.add(var, 0, 0);
        EyeItem item = new EyeItem(16, 16, this.device.getCurrency());
        panel.add(item, 0, 12);
        EyeTextField number = new EyeTextField(width - 64, 16);
        int curAmount = this.device.getUser().m_150109_().m_18947_(this.device.getCurrency().m_41720_());
        number.setAllowed("[0-9]+");
        number.setLimit(3);
        number.setInput("" + (curAmount > 64 ? 64 : curAmount));
        panel.add(number, 20, 12);
        EyeButton add = new EyeButton(42, 16, new Line("text.eyemod.add"));
        add.setColor(this.getAppColor());
        add.setAction(() -> {
            String input = number.getInput();
            if (input.matches("[0-9]+")) {
                int amount = Integer.parseInt(input);
                boolean s = this.device.addMoney(amount > 64 ? 64 : amount);
                this.refresh();
            }
        });
        panel.add(add, width - 42, 12);
        set.add(panel);
    }

    private void customization(List<EyeWidget> set, int width) {
        EyeLabel gen = new EyeLabel(width, 16, new Line("text.eyemod.settings_customization"));
        gen.setBack(this.getSecondary());
        set.add(gen);
        set.add(this.getColorSet(width, "device", "text.eyemod.settings_border", this.border));
        set.add(this.getColorSet(width, "background", "text.eyemod.settings_background", this.back));
        EyeButton custom = new EyeButton(width, 16, new Line("text.eyemod.settings_custom"));
        custom.setColor(this.getAppColor());
        custom.setAction(() -> {
            PhotoPane pho = new PhotoPane(this, 96, this.getHeight() - 32);
            pho.setAction(() -> {
                String photo = pho.getPhoto();
                if (photo != null && !photo.isEmpty()) {
                    this.device.settings.setString("background", photo);
                }
                this.device.onRefresh(this);
            });
            this.openPane(pho);
        });
        set.add(custom);
    }

    private void privacy(List<EyeWidget> set, int width) {
        EyeLabel gen = new EyeLabel(width, 16, new Line("text.eyemod.settings_privacy"));
        gen.setBack(this.getSecondary());
        set.add(gen);
        EyeToggle face = this.getToggle(width, new Line("text.eyemod.settings_face"), "faceid");
        set.add(face);
        EyeToggle locpanel = this.getToggle(width, new Line("text.eyemod.settings_location"), "location");
        set.add(locpanel);
        EyeToggle not = this.getToggle(width, new Line("text.eyemod.settings_notifications"), "notification");
        set.add(not);
    }

    private void eyenet(List<EyeWidget> set, int width) {
        EyeLabel gen = new EyeLabel(width, 16, new Line("text.eyemod.settings_eyenet"));
        gen.setBack(this.getSecondary());
        set.add(gen);
        EyePanel password = new EyePanel(width, 32);
        EyeLabel enter = new EyeLabel(width, 14, new Line("text.eyemod.settings_enterpassword"));
        enter.setBack(-3223858);
        EyeTextField pw = new EyeTextField(width - 34, 16);
        pw.setInput(this.device.data.getString("net"));
        pw.setLimit(16);
        pw.setText(new Line("text.eyemod.settings_password"));
        EyeButton setpw = new EyeButton(32, 16, new Line("text.eyemod.set"));
        setpw.setColor(this.appColor);
        setpw.setAction(() -> this.device.data.setString("net", pw.getInput()));
        password.add(enter, 0, 0);
        password.add(pw, 0, 16);
        password.add(setpw, width - 32, 16);
        set.add(password);
        EyeButton disc = new EyeButton(width, 16, new Line("text.eyemod.settings_disconnect"));
        disc.setColor(-292985);
        disc.setAction(() -> {
            this.device.data.remove("net");
            this.device.data.remove("router");
        });
        set.add(disc);
        EyeButton routerman = new EyeButton(width, 16, new Line("text.eyemod.settings_managenet"));
        routerman.setAction(() -> {
            RouterPane r = new RouterPane(this, this.getWidth() - 4, this.getHeight() - 4);
            this.openPane(r);
        });
        set.add(routerman);
    }

    private EyeToggle getToggle(int width, Line line, String key) {
        EyeToggle tog = new EyeToggle(20, 12);
        tog.setText(line);
        tog.setState(this.device.settings.getBool(key));
        tog.setAction(() -> this.device.settings.setBool(key, tog.getToggle()));
        return tog;
    }

    private EyePanel getColorSet(int width, String key, String title, int[] colors) {
        EyePanel panel = new EyePanel(width, 30);
        int sx = width / colors.length;
        EyeLabel lab = new EyeLabel(width, 10, new Line(title));
        lab.setAlignment(1, 0);
        panel.add(lab, 0, 0);
        for (int i = 0; i < colors.length; ++i) {
            int id = i;
            EyeButton clr = new EyeButton(20, 20);
            if (colors[i] != 0) {
                clr.setColor(colors[i]);
                clr.setAction(() -> {
                    this.device.settings.setInt(key, colors[id]);
                    this.refresh();
                });
            } else {
                clr.setColor(-12303292, -1);
                clr.setIcon(EyeLib.COLOR);
                clr.setAction(() -> {
                    ColorPane c = new ColorPane(this, width, 70);
                    if (this.device.settings.get(key).m_7060_() == Naming.Type.INT.type) {
                        c.setValue(this.device.settings.getInt(key));
                    }
                    c.setAction(() -> {
                        this.device.settings.setInt(key, c.getColor());
                        this.refresh();
                    });
                    this.openPane(c);
                });
            }
            panel.add(clr, i * (sx + 1), 10);
        }
        return panel;
    }

    @Override
    public void tick(int mx, int my) {
        this.battery.setValue(this.device.getItem().m_41776_() - this.device.getItem().m_41773_());
        super.tick(mx, my);
    }

    @Override
    public void onRefresh() {
        this.lastScroll = this.settings.getScroll();
        this.device.onRefresh(this);
        this.settings.setScroll(this.lastScroll);
    }

    @Override
    public void close() {
        super.close();
    }

    public int getSettingsWidth() {
        return this.getWidth() - 14;
    }
}

