/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.stock;

import com.podloot.eyemod.EyeCommands;
import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.util.Time;
import com.podloot.eyemod.gui.util.commands.Command;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeList;
import com.podloot.eyemod.lib.gui.widgets.EyeText;
import com.podloot.eyemod.lib.gui.widgets.EyeTextField;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;

public class AppConsole
extends App {
    String lastCmd = "";
    EyeList console;

    public AppConsole() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appconsole.png"), -13421773, "Eye");
    }

    @Override
    public boolean load() {
        this.console = new EyeList(this.getWidth() - 4, this.getHeight() - 26, EyeWidget.Axis.VERTICAL);
        this.console.add(this.getMessage(Time.getTime() + " - Console"));
        this.console.add(this.getMessage("Use: help for more info"));
        this.console.setScroll(-999);
        this.add(this.console, 2, 2);
        EyeTextField text = new EyeTextField(this.getWidth() - 26, 20);
        text.setSuggest(this.getCommands());
        text.setText(new Line("text.eyemod.console_command"));
        this.add(text, 2, this.getHeight() - 22);
        EyeButton send = new EyeButton(20, 20, EyeLib.RIGHT);
        send.setColor(this.getAppColor(), -1);
        send.setAction(() -> {
            this.console.add(this.getMessage("> " + text.getInput()));
            String output = this.device.command.execute(text.getInput());
            this.console.add(this.getMessage(output));
            this.lastCmd = text.getInput();
            text.setInput("");
            this.console.updateItems();
            this.console.setScroll(-999);
        });
        this.add(send, this.getWidth() - 22, this.getHeight() - 22);
        text.setAction(send.getAction());
        text.setOnUp(() -> text.setInput(this.lastCmd));
        return true;
    }

    public String[] getCommands() {
        ArrayList<Object> sug = new ArrayList<Object>();
        for (Command c : EyeCommands.getCommands()) {
            sug.add(c.getCommand());
            for (String s : c.getSub()) {
                sug.add(c.getCommand() + " " + s);
            }
        }
        return sug.toArray(new String[0]);
    }

    public EyeWidget getMessage(String msg) {
        Line l = new Line(msg).setScale(0.8f);
        if (!msg.startsWith("> ")) {
            l.setStyle(false, true);
            l.setColor(-7829368);
        }
        EyeText label = new EyeText(this.getWidth() - 20, l);
        label.setBack(-13421773);
        label.setAlignment(1, 0);
        return label;
    }

    @Override
    public void close() {
        super.close();
    }
}

