/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.server;

import com.podloot.eyemod.gui.apps.AppPoint;
import com.podloot.eyemod.gui.elements.DimensionButton;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Pos;
import com.podloot.eyemod.lib.gui.util.Space;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import com.podloot.eyemod.network.PacketHandler;
import com.podloot.eyemod.network.ServerTeleport;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;

public class AppSpawn
extends AppPoint {
    public AppSpawn() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appspawn.png"), -1464367, "EyeServer");
    }

    @Override
    public boolean load() {
        ListTag spawns = this.device.config.getSpawns();
        boolean allow_home = this.device.config.getBoolean("allow_home");
        if (this.device.data.has("home") && allow_home) {
            spawns.add((Object)StringTag.m_129297_((String)this.device.data.getString("home")));
        }
        this.setList(new Space(2, 2, this.getWidth() - 4, this.getHeight() - 22), spawns);
        EyeButton home = new EyeButton(62, 16, new Line("text.eyemod.spawn_home"));
        home.setColor(this.appColor);
        home.setEnabled(allow_home);
        home.setAction(() -> {
            Pos pos = new Pos(this.device.getUser().m_20183_(), this.device.getWorldID(), "Home");
            this.device.data.setPos("home", pos);
            this.refresh();
        });
        this.add(home, this.getWidth() - 64, this.getHeight() - 18);
        EyeButton delete = new EyeButton(16, 16, EyeLib.DELETE);
        delete.setColor(-12303292, -292985);
        delete.setEnabled(allow_home);
        delete.setHover(new Line("text.eyemod.hover_deletehome"));
        delete.setAction(() -> {
            this.device.data.remove("home");
            this.refresh();
        });
        this.add(delete, this.getWidth() - 84, this.getHeight() - 18);
        return super.load();
    }

    @Override
    public EyeWidget getPanel(int index, Pos pos) {
        EyePanel pan = new EyePanel(this.getWidth() - 14, 34);
        pan.setBack(-12303292);
        if (pos == null) {
            return pan;
        }
        EyeLabel name = new EyeLabel(this.getWidth() - 14 - 20, 14, new Line(pos.getName()));
        name.setBack(this.getAppColor());
        pan.add(name, 2, 2);
        BlockPos c = pos.getPos();
        EyeLabel coords = new EyeLabel(this.getWidth() - 14 - 48, 14, new Line(c.m_123341_() + "/" + c.m_123342_() + "/" + c.m_123343_()));
        coords.setBack(-3223858);
        pan.add(coords, 2, 18);
        DimensionButton db = new DimensionButton(14, 14, pos.getWorld());
        db.setEnabled(false);
        pan.add(db, this.getWidth() - 14 - 16, 2);
        EyeButton warp = new EyeButton(42, 14, new Line("text.eyemod.spawn"));
        warp.setColor(this.appColor);
        warp.setAction(() -> PacketHandler.INSTANCE.sendToServer((Object)new ServerTeleport(this.device.getUser().m_6302_(), pos.getPos(), pos.getWorld())));
        pan.add(warp, this.getWidth() - 16 - 42, 18);
        return pan;
    }
}

