/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.server;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.lib.gui.panels.EyeListPanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeList;
import com.podloot.eyemod.lib.gui.widgets.EyePlayer;
import com.podloot.eyemod.lib.gui.widgets.EyeTextField;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import com.podloot.eyemod.network.PacketHandler;
import com.podloot.eyemod.network.ServerKick;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class AppPlayers
extends App {
    EyeList players;

    public AppPlayers() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appplayers.png"), -1449947, "EyeServer");
    }

    @Override
    public boolean load() {
        this.players = new EyeList(this.getWidth() - 4, this.getHeight() - 22, EyeWidget.Axis.VERTICAL);
        for (Player p : this.device.getUser().f_19853_.m_6907_()) {
            this.players.add(this.getPlayer(p));
        }
        this.add(this.players, 2, 2);
        EyeTextField reason = new EyeTextField(this.getWidth() - 48, 16);
        reason.setText(new Line("text.eyemod.reason"));
        reason.setSuggest(new String[]{"No reason", "AFK", "Hacking"});
        this.add(reason, 2, this.getHeight() - 18);
        EyeButton kick = new EyeButton(42, 16, new Line("text.eyemod.kick"));
        kick.setColor(this.appColor);
        kick.setAction(() -> {
            String r = (reason.getInput().isEmpty() ? "Kicked" : reason.getInput()) + " (kicked by: " + this.device.getUser().m_6302_() + ")";
            if (this.players.getSelected() != null) {
                PacketHandler.INSTANCE.sendToServer((Object)new ServerKick((String)this.players.getSelected().getData(), r));
            }
            this.refresh();
        });
        this.add(kick, this.getWidth() - 44, this.getHeight() - 18);
        return true;
    }

    public EyeListPanel getPlayer(Player player) {
        EyeListPanel lp = new EyeListPanel(this.players, 16);
        EyeLabel name = new EyeLabel(lp.getWidth() - 18, 16, new Line(player.m_6302_()));
        name.setBack(this.appColor);
        lp.add(name, 18, 0);
        EyePlayer pl = new EyePlayer(16, 16, player.m_6302_());
        lp.add(pl, 0, 0);
        lp.setData(player.m_6302_());
        return lp;
    }
}

