/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.op;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.util.Time;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeIcon;
import com.podloot.eyemod.lib.gui.widgets.EyePlane;
import com.podloot.eyemod.lib.gui.widgets.EyeSlider;
import com.podloot.eyemod.network.PacketHandler;
import com.podloot.eyemod.network.ServerWeather;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class AppWorld
extends App {
    public AppWorld() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appworld.png"), -13883531, "EyeOP");
    }

    @Override
    public boolean load() {
        EyeButton sun = new EyeButton(32, 32, EyeLib.SUNNY);
        sun.setOffset(2);
        sun.setColor(this.appColor);
        boolean snow = ((Biome)this.device.getUser().f_19853_.m_204166_(this.device.getUser().m_20183_()).m_203334_()).m_198904_(this.device.getUser().m_20183_());
        EyeButton rain = new EyeButton(32, 32, snow ? EyeLib.SNOW : EyeLib.RAIN);
        rain.setOffset(2);
        rain.setColor(this.appColor);
        EyeButton thunder = new EyeButton(32, 32, EyeLib.THUNDER);
        thunder.setColor(this.appColor);
        thunder.setOffset(2);
        sun.setAction(() -> PacketHandler.INSTANCE.sendToServer((Object)new ServerWeather(1, 1000000)));
        rain.setAction(() -> PacketHandler.INSTANCE.sendToServer((Object)new ServerWeather(2, 1000000)));
        thunder.setAction(() -> PacketHandler.INSTANCE.sendToServer((Object)new ServerWeather(3, 1000000)));
        this.add(sun, 8, 8);
        this.add(rain, this.getWidth() / 2 - 16, 9);
        this.add(thunder, this.getWidth() - 40, 8);
        EyeButton morning = new EyeButton(24, 24, EyeLib.MORNING);
        morning.setColor(this.appColor);
        morning.setOffset(2);
        EyeButton midday = new EyeButton(24, 24, EyeLib.MIDDAY);
        midday.setColor(this.appColor);
        midday.setOffset(2);
        EyeButton evening = new EyeButton(24, 24, EyeLib.EVENING);
        evening.setColor(this.appColor);
        evening.setOffset(2);
        EyeButton midnight = new EyeButton(24, 24, EyeLib.MIDNIGHT);
        midnight.setColor(this.appColor);
        midnight.setOffset(2);
        morning.setAction(() -> PacketHandler.INSTANCE.sendToServer((Object)new ServerWeather(0, 0)));
        midday.setAction(() -> PacketHandler.INSTANCE.sendToServer((Object)new ServerWeather(0, 4000)));
        evening.setAction(() -> PacketHandler.INSTANCE.sendToServer((Object)new ServerWeather(0, 12000)));
        midnight.setAction(() -> PacketHandler.INSTANCE.sendToServer((Object)new ServerWeather(0, 16000)));
        this.add(morning, 8, 48);
        this.add(midday, this.getWidth() / 2 - 30, 48);
        this.add(evening, this.getWidth() / 2 + 6, 48);
        this.add(midnight, this.getWidth() - 32, 48);
        EyePlane back = new EyePlane(this.getWidth() - 4, 32, this.appColor);
        this.add(back, 2, this.getHeight() - 34);
        EyeIcon cycle = new EyeIcon(144, 32, EyeLib.CYCLE);
        this.add(cycle, 3, this.getHeight() - 68);
        EyeSlider time = new EyeSlider(this.getWidth() - 12, 24, 0, 48);
        time.setText(new Line("text.eyemod.world_time"));
        time.setShowValue(() -> Time.time(time.getValue() * 500 + 16000));
        time.setAction(() -> PacketHandler.INSTANCE.sendToServer((Object)new ServerWeather(0, time.getValue() * 500 + 16000)));
        this.add(time, 6, this.getHeight() - 30);
        return true;
    }
}

