/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.base;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Color;
import com.podloot.eyemod.lib.gui.util.Image;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeIcon;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeVariable;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class AppWeather
extends App {
    HashMap<String, Image> weather = new HashMap();

    public AppWeather() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appweather.png"), -5389335, "Eye");
        this.weather.put("text.eyemod.weather_sunny", EyeLib.SUNNY);
        this.weather.put("text.eyemod.weather_raining", EyeLib.RAIN);
        this.weather.put("text.eyemod.weather_snowing", EyeLib.SNOW);
        this.weather.put("text.eyemod.weather_thunder", EyeLib.THUNDER);
    }

    @Override
    public boolean load() {
        this.add(this.getWeatherPanel(), 2, 2);
        this.add(this.getRainPanel(), 2, 36);
        this.add(this.getBiomePanel(), 2, 70);
        this.add(this.getLocationPanel(), 2, 104);
        return true;
    }

    public EyePanel getWeatherPanel() {
        EyePanel weath = new EyePanel(this.getWidth() - 4, 32);
        weath.setBack(this.appColor);
        String wn = this.device.getWeather();
        if (this.weather.containsKey(wn)) {
            EyeIcon w = new EyeIcon(24, 24, this.weather.get(wn));
            weath.add(w, 4, 4);
        }
        EyeLabel wl = new EyeLabel(42, 16, new Line(wn).setStyle(true, false));
        wl.setAlignment(1, 1);
        weath.add(wl, 26, 5);
        EyeLabel temp = new EyeLabel(42, 16, new Line("text.eyemod.weather_degrees").setStyle(false, true));
        temp.setAlignment(1, 1);
        temp.setVariable("" + this.device.getTemp());
        weath.add(temp, 26, 15);
        return weath;
    }

    public EyePanel getRainPanel() {
        EyePanel weath = new EyePanel(this.getWidth() - 4, 32);
        weath.setBack(this.appColor);
        EyeIcon r = new EyeIcon(24, 24, EyeLib.RAIN);
        weath.add(r, 4, 4);
        EyeVariable wl = new EyeVariable(42, 16, new Line("text.eyemod.weather_humidity"));
        wl.setVariable(() -> this.getHumidity());
        wl.setAlignment(1, 1);
        weath.add(wl, 26, 5);
        EyeLabel rc = new EyeLabel(42, 16, new Line("text.eyemod.weather_rain"));
        rc.setVariable(this.getRainChance());
        rc.setAlignment(1, 1);
        weath.add(rc, 26, 15);
        return weath;
    }

    public EyePanel getBiomePanel() {
        BlockPos bp = this.device.getUser().m_20183_();
        String name = ((ResourceKey)this.device.getUser().f_19853_.m_204166_(bp).m_203543_().get()).m_135782_().m_135815_();
        Holder<Biome> b = this.getBiomeKey();
        EyePanel biome = new EyePanel(this.getWidth() - 4, 32);
        biome.setBack(-7220636);
        EyeIcon base = new EyeIcon(24, 24, EyeLib.BIOME);
        biome.add(base, 4, 4);
        EyeIcon fog = new EyeIcon(24, 24, EyeLib.BIOME_FOG);
        Color c = new Color(((Biome)b.m_203334_()).m_47539_());
        fog.setColor(0, new Color(c.getRed(), c.getGreen(), c.getBlue()).getRGB());
        biome.add(fog, 4, 4);
        EyeIcon water = new EyeIcon(24, 24, EyeLib.BIOME_WATER);
        water.setColor(0, this.getWaterColor(b));
        biome.add(water, 4, 4);
        EyeIcon grass = new EyeIcon(24, 24, EyeLib.BIOME_GRASS);
        grass.setColor(0, this.getGrassColor(b));
        biome.add(grass, 4, 4);
        EyeLabel rc = new EyeLabel(42, 16, new Line(name));
        rc.setAlignment(1, 1);
        biome.add(rc, 26, 15);
        EyeLabel title = new EyeLabel(42, 16, new Line("text.eyemod.biome").setStyle(false, true));
        title.setAlignment(1, 1);
        biome.add(title, 26, 5);
        return biome;
    }

    public EyePanel getLocationPanel() {
        EyePanel loc = new EyePanel(this.getWidth() - 4, 32);
        loc.setBack(-3223858);
        EyeIcon r = new EyeIcon(24, 24, EyeLib.MAP);
        loc.add(r, 4, 4);
        BlockPos bp = this.device.getUser().m_20183_();
        EyeLabel pos = new EyeLabel(42, 16, new Line("X: " + bp.m_123341_() + " Y: " + bp.m_123342_() + " Z: " + bp.m_123343_()));
        pos.setAlignment(1, 1);
        loc.add(pos, 26, 5);
        EyeLabel world = new EyeLabel(42, 16, new Line(this.device.getWorldID().m_135815_()).setStyle(false, true));
        world.setAlignment(1, 1);
        loc.add(world, 26, 15);
        return loc;
    }

    public String getRainChance() {
        float t = ((Biome)this.getBiomeKey().m_203334_()).m_47548_();
        return (int)(t * 100.0f) + "%";
    }

    public String getHumidity() {
        float t = this.device.getUser().f_19853_.m_46722_(0.5f);
        return (int)(t * 100.0f) + "%";
    }

    private Holder<Biome> getBiomeKey() {
        BlockPos bp = this.device.getUser().m_20183_();
        return this.device.getUser().f_19853_.m_204166_(bp);
    }

    public int getWaterColor(Holder<Biome> b) {
        if (this.device.getWorldID() == Naming.Dim.END.id) {
            return -14540254;
        }
        if (this.device.getWorldID() == Naming.Dim.NETHER.id) {
            return -2133722;
        }
        Color c = new Color(((Biome)b.get()).m_47560_());
        return new Color(c.getRed(), c.getGreen(), c.getBlue()).getRGB();
    }

    public int getGrassColor(Holder<Biome> b) {
        if (this.device.getWorldID() == Naming.Dim.OVERWORLD.id) {
            Color c = new Color(((Biome)b.get()).m_47542_());
            return new Color(c.getRed(), c.getGreen(), c.getBlue()).getRGB();
        }
        if (this.device.getWorldID() == Naming.Dim.END.id) {
            return -1185382;
        }
        return -6800067;
    }
}

