/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.base;

import com.podloot.eyemod.gui.apps.AppPoint;
import com.podloot.eyemod.gui.elements.DimensionButton;
import com.podloot.eyemod.gui.presets.PosPreset;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Pos;
import com.podloot.eyemod.lib.gui.util.Space;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeTextField;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class AppWaypoint
extends AppPoint {
    public AppWaypoint() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appwaypoint.png"), -9388078, "Eye");
    }

    @Override
    public boolean load() {
        this.setList(new Space(2, 2, this.getWidth() - 4, this.getHeight() - 56), this.device.data.getList("waypoints", Naming.Type.STRING));
        EyeTextField name = new EyeTextField(this.getWidth() - 4, 16);
        name.setText(new Line("text.eyemod.name"));
        name.setDisallowed("[|]+");
        this.add(name, 2, this.getHeight() - 52);
        PosPreset pos = new PosPreset(this, this.getWidth() - 4);
        pos.setButton(new Line("text.eyemod.add"), this.getAppColor(), () -> {
            if (this.device.hasData()) {
                ResourceLocation w = pos.getWorld();
                BlockPos p = pos.getPos();
                String n = name.getInput();
                n = n.isEmpty() || n == "" ? "Waypoint" : n;
                Pos way = new Pos(p, w, n);
                List<Pos> listpos = this.device.data.getPosList("waypoints");
                listpos.add(way);
                this.device.data.setPosList("waypoints", listpos);
                this.refresh();
            }
        });
        this.add(pos, 2, this.getHeight() - 34);
        return super.load();
    }

    @Override
    public EyePanel getPanel(int index, Pos waypoint) {
        EyePanel pan = new EyePanel(this.getWidth() - 14, 34);
        pan.setBack(-12303292);
        EyeLabel name = new EyeLabel(this.getWidth() - 14 - 20, 14, new Line(waypoint.getName()));
        name.setBack(this.getAppColor());
        pan.add(name, 2, 2);
        BlockPos c = waypoint.getPos();
        EyeLabel coords = new EyeLabel(this.getWidth() - 14 - 20, 14, new Line(c.m_123341_() + "/" + c.m_123342_() + "/" + c.m_123343_()));
        coords.setBack(this.getAppColor());
        pan.add(coords, 18, 18);
        DimensionButton db = new DimensionButton(14, 14, waypoint.getWorld());
        db.setEnabled(false);
        pan.add(db, 2, 18);
        EyeButton delete = new EyeButton(14, 14, EyeLib.DELETE);
        delete.setColor(-12303292, -292985);
        delete.setAction(() -> {
            this.device.data.removeFromList("waypoints", index);
            this.refresh();
        });
        pan.add(delete, this.getWidth() - 14 - 16, 2);
        return pan;
    }
}

