/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.base;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.panes.ConfirmPane;
import com.podloot.eyemod.gui.panes.InputPane;
import com.podloot.eyemod.gui.presets.PhotosPreset;
import com.podloot.eyemod.gui.util.Photos;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import net.minecraft.resources.ResourceLocation;

public class AppPhotos
extends App {
    public AppPhotos() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appphotos.png"), -6572859, "Eye");
    }

    @Override
    public boolean load() {
        PhotosPreset photos = new PhotosPreset(this, this.getWidth() - 14, this.getHeight() - 20);
        this.add(photos, 7, 2);
        EyeButton delete = new EyeButton(14, 14, EyeLib.DELETE);
        delete.setColor(-12303292, -292985);
        delete.setAction(() -> {
            ConfirmPane del = new ConfirmPane(this, this.getWidth() - 4, 38, new Line("text.eyemod.photos_delete"), true);
            del.setAction(() -> {
                String photo = photos.getPhoto();
                if (photo != null && !photo.isEmpty()) {
                    Photos.deleteShot(photo);
                    this.refresh();
                }
            });
            this.openPane(del);
        });
        this.add(delete, this.getWidth() - 21, this.getHeight() - 16);
        EyeButton name = new EyeButton(this.getWidth() - 30, 14, new Line(""));
        name.setColor(this.getAppColor());
        name.setAction(() -> {
            InputPane in = new InputPane(this, this.getWidth() - 4, 52, new Line("text.eyemod.photos_rename"));
            in.getTextField().setAllowed("[0-9a-zA-Z_]+");
            in.getTextField().setLimit(24);
            in.setAction(() -> {
                String i = in.getInput();
                String photo = photos.getPhoto();
                if (i != null && !i.isEmpty() && photo != null && !photo.isEmpty()) {
                    Photos.renameShot(photo, i);
                    this.refresh();
                }
            });
            this.openPane(in);
        });
        this.add(name, 7, this.getHeight() - 16);
        photos.getList().onSelect(() -> {
            String photo = photos.getPhoto();
            name.setText(new Line(photo != null ? photo : ""));
        });
        return true;
    }

    @Override
    public EyeWidget getNotification(String message, int width) {
        EyeButton msg = new EyeButton(width, 16, new Line(message).setScale(0.75f));
        msg.setColor(this.getAppColor());
        msg.setAction(() -> {
            if (this.device != null && !this.device.isLocked()) {
                this.device.openApp(this);
            }
        });
        return msg;
    }
}

