/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.base;

import com.podloot.eyemod.blocks.entities.RouterEntity;
import com.podloot.eyemod.gui.apps.AppTextList;
import com.podloot.eyemod.gui.panes.ConfirmPane;
import com.podloot.eyemod.gui.panes.InputPane;
import com.podloot.eyemod.gui.panes.PostPane;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyeBoxPanel;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Space;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeText;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import com.podloot.eyemod.network.PacketHandler;
import com.podloot.eyemod.network.ServerRouterData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class AppNetwork
extends AppTextList {
    public AppNetwork() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appnet.png"), -10983488, "Eye");
        this.setColor(-3223858, -12303292);
    }

    @Override
    public boolean load() {
        this.setColor(-5592406, -3355444);
        RouterEntity re = this.device.connect.getRouterData();
        if (re != null) {
            this.setList(new Space(2, 2, this.getWidth() - 4, this.getHeight() - 22), re.data.m_128437_("posts", (int)Naming.Type.COMPOUND.type));
        }
        EyeButton newpost = new EyeButton(this.getWidth() - 4, 16, new Line("text.eyemod.network_create"));
        newpost.setColor(this.appColor);
        newpost.setAction(() -> {
            if (this.device.hasRouterData()) {
                PostPane create = new PostPane(this, this.getWidth() - 4, this.getHeight() - 4, new Line("text.eyemod.message"));
                create.setAction(() -> {
                    CompoundTag msg = new CompoundTag();
                    msg.m_128359_("title", create.getTitle());
                    msg.m_128359_("sen", this.device.getOwner());
                    msg.m_128359_("msg", create.getMessage());
                    PacketHandler.INSTANCE.sendToServer((Object)new ServerRouterData(this.device.connect.getRouter(), Naming.Action.ADD_TO_LIST, "posts", (Tag)msg));
                    this.refresh();
                });
                this.openPane(create);
            }
        });
        this.add(newpost, 2, this.getHeight() - 18);
        return super.load();
    }

    @Override
    public EyeWidget getMain(EyeBoxPanel box, int index, CompoundTag info) {
        EyePanel post = new EyePanel(box.getWidth() - 10, 0);
        EyeText title = new EyeText(post.getWidth() - 4, new Line(info.m_128461_("title")).setStyle(true, false));
        title.setAlignment(1, 0);
        title.setBack(this.getPrimary());
        EyeText msg = new EyeText(post.getWidth() - 4, new Line(info.m_128461_("msg")));
        msg.setAlignment(1, 0);
        msg.setBack(this.getPrimary());
        post.setSize(post.getWidth(), 24 + title.getHeight() + msg.getHeight());
        EyeLabel writer = new EyeLabel(post.getWidth() - 18, 14, new Line("By: " + info.m_128461_("sen")).setScale(0.8f).setStyle(false, true));
        writer.setAlignment(1, -1);
        post.add(title, 2, 2);
        post.add(msg, 2, 4 + title.getHeight());
        post.add(writer, 2, post.getHeight() - 22);
        EyeWidget reactions = this.getExpendable(box, index, info);
        if (info.m_128461_("sen").equals(this.device.getOwner()) || this.device.connect.getRouterData().owner.equals(this.device.getOwner())) {
            EyeButton delete = new EyeButton(14, 14, EyeLib.DELETE);
            delete.setColor(-12303292, -292985);
            delete.setAction(() -> {
                ConfirmPane pane = new ConfirmPane(this, this.getWidth() - 4, 42, new Line("text.eyemod.network_delete"), true);
                pane.setAction(() -> {
                    PacketHandler.INSTANCE.sendToServer((Object)new ServerRouterData(this.device.connect.getRouter(), Naming.Action.REMOVE, "posts", (Tag)IntTag.m_128679_((int)this.getIndex(info))));
                    this.refresh();
                });
                this.openPane(pane);
            });
            post.add(delete, post.getWidth() - 64, post.getHeight() - 18);
        }
        post.add(this.getFold(box, reactions, new Space(42, 14), new Line("text.eyemod.open"), this.appColor, new Line("text.eyemod.close"), -292985), post.getWidth() - 44, post.getHeight() - 18);
        return post;
    }

    @Override
    public EyeWidget getExpendable(EyeBoxPanel box, int index, CompoundTag info) {
        EyePanel rec = new EyePanel(box.getWidth() - 10, 0);
        ListTag re = info.m_128437_("re", (int)Naming.Type.STRING.type);
        int h = 0;
        for (int i = 0; i < re.size(); ++i) {
            EyeText r = new EyeText(rec.getWidth() - 4, new Line(re.m_128778_(i)));
            r.setAlignment(1, 0);
            r.setBack(this.getSecondary());
            rec.add(r, 2, h);
            h += r.getHeight() + 2;
        }
        rec.setHeight(h + 18);
        EyeButton react = new EyeButton(rec.getWidth() - 4, 14, new Line("text.eyemod.react"));
        react.setColor(-12303292);
        react.setAction(() -> {
            if (this.device.hasRouterData()) {
                InputPane input = new InputPane(this, this.getWidth() - 4, 54, new Line("text.eyemod.network_reaction"));
                input.setAction(() -> {
                    CompoundTag reaction = new CompoundTag();
                    reaction.m_128405_("i", this.getIndex(info));
                    reaction.m_128359_("re", this.device.getOwner() + ": " + input.getInput());
                    PacketHandler.INSTANCE.sendToServer((Object)new ServerRouterData(this.device.connect.getRouter(), Naming.Action.REACT_TO_POST, "posts", (Tag)reaction));
                    this.refresh();
                });
                this.openPane(input);
            }
        });
        rec.add(react, 2, rec.getHeight() - 18);
        return rec;
    }

    public int getIndex(CompoundTag info) {
        ListTag psts = this.device.connect.getRouterData().data.m_128437_("posts", (int)Naming.Type.COMPOUND.type);
        for (int i = 0; i < psts.size(); ++i) {
            CompoundTag p = psts.m_128728_(i);
            if (!p.m_128461_("title").equals(info.m_128461_("title")) || !p.m_128461_("msg").equals(info.m_128461_("msg"))) continue;
            return i;
        }
        return -1;
    }
}

