/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.base;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.elements.DeviceButton;
import com.podloot.eyemod.gui.util.Music;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyeListPanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeItem;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeList;
import com.podloot.eyemod.lib.gui.widgets.EyePlane;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;

public class AppMusic
extends App {
    EyeList songs;
    Map<SoundEvent, RecordItem> discs = new HashMap<SoundEvent, RecordItem>();

    public AppMusic() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appmusic.png"), -2236963, "Eye");
        this.discs.put(SoundEvents.f_215723_, (RecordItem)Items.f_220217_);
        this.discs.put(SoundEvents.f_12084_, (RecordItem)Items.f_42710_);
        this.discs.put(SoundEvents.f_12085_, (RecordItem)Items.f_42752_);
        this.discs.put(SoundEvents.f_12086_, (RecordItem)Items.f_42702_);
        this.discs.put(SoundEvents.f_12140_, (RecordItem)Items.f_42701_);
        this.discs.put(SoundEvents.f_12141_, (RecordItem)Items.f_42703_);
        this.discs.put(SoundEvents.f_12142_, (RecordItem)Items.f_42704_);
        this.discs.put(SoundEvents.f_12143_, (RecordItem)Items.f_42705_);
        this.discs.put(SoundEvents.f_12144_, (RecordItem)Items.f_42706_);
        this.discs.put(SoundEvents.f_184218_, (RecordItem)Items.f_186363_);
        this.discs.put(SoundEvents.f_12145_, (RecordItem)Items.f_42712_);
        this.discs.put(SoundEvents.f_12146_, (RecordItem)Items.f_42707_);
        this.discs.put(SoundEvents.f_12147_, (RecordItem)Items.f_42708_);
        this.discs.put(SoundEvents.f_12148_, (RecordItem)Items.f_42711_);
        this.discs.put(SoundEvents.f_12149_, (RecordItem)Items.f_42709_);
    }

    @Override
    public boolean load() {
        this.songs = new EyeList(this.getWidth() - 4, this.getHeight() - 42, EyeWidget.Axis.VERTICAL);
        for (int i = 0; i < Music.songs.length; ++i) {
            this.songs.add(this.getSongPanel(i, Music.songs[i]));
        }
        this.add(this.songs, 2, 2);
        DeviceButton previous = new DeviceButton(32, 32, EyeLib.MUSIC_PREVIOUS);
        previous.setColor(-12303292);
        DeviceButton pause = new DeviceButton(32, 32, EyeLib.MUSIC_PAUSE);
        pause.setColor(-12303292);
        DeviceButton play = new DeviceButton(32, 32, EyeLib.MUSIC_PLAY);
        play.setColor(-12303292);
        DeviceButton next = new DeviceButton(32, 32, EyeLib.MUSIC_NEXT);
        next.setColor(-12303292);
        play.setAction(() -> {
            EyeListPanel sel = this.songs.getSelected();
            if (sel != null) {
                Object index = sel.getData();
                if (index != null && index instanceof Integer) {
                    Music.play((Entity)this.device.getUser(), (Integer)index);
                } else {
                    Music.play((Entity)this.device.getUser(), Music.song);
                }
            } else {
                Music.play((Entity)this.device.getUser(), Music.song);
            }
        });
        pause.setAction(() -> Music.stop());
        previous.setAction(() -> {
            if (Music.song > 0) {
                Music.play((Entity)this.device.getUser(), Music.song - 1);
            } else {
                Music.play((Entity)this.device.getUser(), Music.songs.length - 1);
            }
        });
        next.setAction(() -> {
            if (Music.song < Music.songs.length - 1) {
                Music.play((Entity)this.device.getUser(), Music.song + 1);
            } else {
                Music.play((Entity)this.device.getUser(), 0);
            }
        });
        EyePlane back = new EyePlane(this.getWidth() - 4, 36, this.getAppColor());
        this.add(back, 2, this.getHeight() - 38);
        this.add(previous, 4, this.getHeight() - 36);
        this.add(pause, this.getWidth() / 2 - 34, this.getHeight() - 36);
        this.add(play, this.getWidth() / 2 + 2, this.getHeight() - 36);
        this.add(next, this.getWidth() - 36, this.getHeight() - 36);
        return true;
    }

    public EyeListPanel getSongPanel(int index, SoundEvent s) {
        String[] ns;
        EyeListPanel song = new EyeListPanel(this.songs, 16);
        ItemStack disc = Items.f_42701_.m_7968_();
        if (this.discs.containsKey(s)) {
            disc = this.discs.get(s).m_7968_();
        }
        EyeItem item = new EyeItem(16, 16, disc);
        song.add(item, 1, 0);
        String n = s.m_11660_().m_135815_();
        if (n.contains(".") && (ns = n.split("\\.")).length >= 1) {
            n = ns[ns.length - 1];
        }
        EyeLabel name = new EyeLabel(song.getWidth() - 18, 16, new Line(n).setStyle(true, true));
        name.setBack(this.getAppColor());
        song.add(name, 18, 0);
        song.setData(index);
        return song;
    }
}

