/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.base;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.presets.PlayerPreset;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeList;
import com.podloot.eyemod.lib.gui.widgets.EyePlayer;
import com.podloot.eyemod.lib.gui.widgets.EyeText;
import com.podloot.eyemod.lib.gui.widgets.EyeTextField;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class AppMessages
extends App {
    int w = this.getWidth() - 14;
    EyePanel chat;
    int chatSize = 0;
    String currentUser;
    String lastMessage;

    public AppMessages() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appmessages.png"), -8537518, "Eye");
    }

    @Override
    public boolean load() {
        this.openUsers(this.getUsers());
        return true;
    }

    public void openUsers(Set<String> users) {
        this.chat = null;
        this.currentUser = null;
        this.chatSize = 0;
        EyeList chats = new EyeList(this.getWidth() - 4, this.getHeight() - 40, EyeWidget.Axis.VERTICAL);
        this.add(chats, 2, 4);
        for (String u : users) {
            chats.add(this.getUserPanel(chats, u));
        }
        PlayerPreset user = new PlayerPreset(this, this.getWidth() - 4);
        user.setButton(new Line("text.eyemod.open"), this.getAppColor(), () -> {
            if (!user.getInput().isEmpty() && user.getInput() != "" && this.device.hasData()) {
                this.clear();
                this.openChat(user.getInput());
            }
        });
        this.add(user, 2, this.getHeight() - 34);
    }

    public EyePanel getUserPanel(EyeList chats, String user) {
        EyePanel panel = new EyePanel(this.getWidth() - 14, 34);
        panel.setBack(-12303292);
        EyePlayer player = new EyePlayer(14, 14, user);
        EyeLabel name = new EyeLabel(this.getWidth() - 14 - 40, 14, new Line(user));
        name.setBack(this.getAppColor());
        panel.add(player, 4, 2);
        panel.add(name, 20, 2);
        EyeButton delete = new EyeButton(14, 14, EyeLib.DELETE);
        delete.setColor(-12303292, -292985);
        delete.setAction(() -> {
            this.deleteChat(user);
            chats.remove(panel);
            this.refresh();
        });
        panel.add(delete, this.getWidth() - 14 - 18, 2);
        EyeButton open = new EyeButton(62, 14);
        open.setText(new Line("text.eyemod.open"));
        open.setColor(this.getAppColor());
        open.setAction(() -> {
            if (!user.isEmpty() && user != "") {
                this.clear();
                this.openChat(user);
            }
        });
        panel.add(open, this.getWidth() - 14 - 66, 18);
        return panel;
    }

    public void openChat(String user) {
        this.currentUser = user;
        ListTag messages = this.getMessages().m_128437_(user, (int)Naming.Type.STRING.type);
        this.chatSize = messages.size();
        EyeButton back = new EyeButton(14, 14, EyeLib.LEFT);
        back.setColor(-12303292);
        back.setAction(() -> {
            this.clear();
            this.openUsers(this.getUsers());
        });
        EyePlayer player = new EyePlayer(14, 14, user);
        EyeLabel name = new EyeLabel(this.getWidth() - 36, 14, new Line(user));
        name.setBack(this.getAppColor());
        this.add(player, 18, 2);
        this.add(name, 34, 2);
        this.add(back, 2, 2);
        this.chat = this.getChat(messages, this.getWidth() - 4, this.getHeight() - 42);
        this.add(this.chat, 2, 18);
        EyeTextField text = new EyeTextField(this.getWidth() - 26, 20);
        text.setText(new Line("text.eyemod.chat_message"));
        this.add(text, 2, this.getHeight() - 22);
        EyeButton send = new EyeButton(20, 20, EyeLib.RIGHT);
        send.setColor(this.appColor, -1);
        send.setAction(() -> {
            if (!text.getInput().isEmpty()) {
                this.device.connect.sendMessage(user, text.getInput());
                text.setInput("");
            }
        });
        this.add(send, this.getWidth() - 22, this.getHeight() - 22);
        text.setAction(send.getAction());
    }

    public EyePanel getChat(ListTag messages, int w, int h) {
        EyePanel chat = new EyePanel(w, h);
        EyeList chats = new EyeList(chat.getWidth(), chat.getHeight(), EyeWidget.Axis.VERTICAL);
        this.chatSize = messages.size();
        for (Tag n : messages) {
            String msg = ((StringTag)n).m_7916_();
            chats.add(this.getMessage(msg));
            this.lastMessage = msg;
        }
        chat.add(chats, 0, 0);
        chats.setScroll(-999);
        return chat;
    }

    public void refreshChat(ListTag messages) {
        if (this.chat != null) {
            this.remove(this.chat);
        }
        this.chat = this.getChat(messages, this.getWidth() - 4, this.getHeight() - 42);
        this.add(this.chat, 2, 18);
    }

    public void deleteChat(String user) {
        CompoundTag msgs = this.getMessages();
        msgs.m_128473_(user);
        this.device.data.setCompoundTag("messages", msgs);
    }

    public EyePanel getMessage(String msg) {
        EyePanel space = new EyePanel(this.getWidth() - 14, 16);
        boolean toself = msg.startsWith("|");
        if (toself) {
            msg = msg.substring(1);
        }
        EyeText plane = new EyeText(this.getWidth() - 14 - 30, new Line(msg));
        plane.setAlignment(1, 0);
        plane.setBack(toself ? -12303292 : this.appColor);
        space.setHeight(plane.getHeight());
        space.add(plane, toself ? 30 : 0, 0);
        return space;
    }

    public Set<String> getUsers() {
        Set users = this.getMessages().m_128431_();
        return users;
    }

    public CompoundTag getMessages() {
        return this.device.data.getNbt().m_128469_("messages");
    }

    @Override
    public void tick(int mx, int my) {
        ListTag m;
        if (this.chat != null && this.currentUser != null && (m = this.getMessages().m_128437_(this.currentUser, (int)Naming.Type.STRING.type)).size() > 0 && !m.m_128778_(m.size() - 1).equals(this.lastMessage)) {
            this.refreshChat(m);
        }
        super.tick(mx, my);
    }

    @Override
    public void onClearData() {
        this.device.data.remove("messages");
    }
}

