/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.base;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.elements.map.Map;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeSlider;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class AppMaps
extends App {
    Map map;

    public AppMaps() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appmaps.png"), -2829909, "Eye");
    }

    @Override
    public boolean load() {
        int ms = this.device.settings.getInt("map_size") * 64 + 64;
        this.map = new Map(this.getWidth() - 4, this.getHeight() - 4, ms < 16 ? 16 : (ms > 1048 ? 1048 : ms), this.device.getUser().m_20183_(), this.device.getUser().f_19853_);
        this.add(this.map, 2, 2);
        this.map.addPlayer((Player)this.device.getUser());
        this.map.addPlayers();
        ListTag spawns = this.device.config.getSpawns();
        if (this.device.data.has("home") && this.device.config.getBoolean("allow_home")) {
            spawns.add((Object)StringTag.m_129297_((String)this.device.data.getString("home")));
        }
        spawns.addAll((Collection)this.device.data.getList("waypoints", Naming.Type.STRING));
        this.map.addWaypoints(spawns);
        return true;
    }

    public String getPos() {
        BlockPos p = this.map.getSelected();
        if (p == null) {
            return "";
        }
        return p.m_123341_() + "/" + p.m_123342_() + "/" + p.m_123343_();
    }

    @Override
    public List<EyeWidget> getSettings(int width) {
        ArrayList<EyeWidget> settings = new ArrayList<EyeWidget>();
        EyeSlider size = new EyeSlider(width, 24, 1, 7);
        size.setText(new Line("text.eyemod.map_size"));
        size.setState(this.device.settings.getInt("map_size"));
        size.setAction(() -> this.device.settings.setInt("map_size", size.getValue()));
        size.setShowValue(() -> size.getValue() * 64 + 64);
        settings.add(size);
        return settings;
    }
}

