/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.base;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeList;
import com.podloot.eyemod.lib.gui.widgets.EyeSlider;
import com.podloot.eyemod.lib.gui.widgets.EyeText;
import com.podloot.eyemod.lib.gui.widgets.EyeTextField;
import com.podloot.eyemod.lib.gui.widgets.EyeToggle;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;

public class AppChat
extends App {
    EyeList chat;
    String lastChat = "";
    int i = 240;

    public AppChat() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appchat.png"), -6896267, "Eye");
    }

    @Override
    public boolean load() {
        this.loadChat();
        EyeTextField text = new EyeTextField(this.getWidth() - 26, 20);
        text.setText(new Line("text.eyemod.chat_message"));
        this.add(text, 2, this.getHeight() - 22);
        EyeButton send = new EyeButton(20, 20, EyeLib.RIGHT);
        send.setColor(this.getAppColor(), -1);
        send.setAction(() -> {
            this.device.connect.sendChat(text.getInput(), "");
            text.setInput("");
            this.refresh();
        });
        this.add(send, this.getWidth() - 22, this.getHeight() - 22);
        text.setAction(send.getAction());
        return true;
    }

    public void loadChat() {
        if (this.chat != null) {
            this.chat.clearList();
            this.remove(this.chat);
        }
        ListTag chats = this.device.data.getList("chat", Naming.Type.STRING);
        this.chat = new EyeList(this.getWidth() - 4, this.getHeight() - 26, EyeWidget.Axis.VERTICAL);
        for (int i = 0; i < chats.size(); ++i) {
            this.chat.add(this.getMessage(chats.m_128778_(i)));
        }
        this.add(this.chat, 2, 2);
        this.chat.setScroll(-999);
    }

    public EyeWidget getMessage(String msg) {
        EyeText label = new EyeText(this.getWidth() - 20, new Line(msg).setScale(0.8f));
        label.setBack(-13421773);
        label.setAlignment(1, 0);
        return label;
    }

    @Override
    public void onRefresh() {
        this.loadChat();
    }

    @Override
    public void onClearData() {
        this.device.data.remove("chat");
    }

    @Override
    public List<EyeWidget> getSettings(int width) {
        ArrayList<EyeWidget> settings = new ArrayList<EyeWidget>();
        EyeToggle local = new EyeToggle(width, 12);
        local.setText(new Line("text.eyemod.chat_local"));
        local.setState(this.device.settings.getBool("chat_local"));
        local.setAction(() -> this.device.settings.setBool("chat_local", local.getToggle()));
        EyeSlider distance = new EyeSlider(width, 24, 1, 32);
        distance.setText(new Line("text.eyemod.chat_distance"));
        distance.setState(this.device.settings.getInt("chat_dis"));
        distance.setAction(() -> this.device.settings.setInt("chat_dis", distance.getValue()));
        distance.setShowValue(() -> distance.getValue() * 16);
        settings.add(local);
        settings.add(distance);
        return settings;
    }

    @Override
    public void tick(int mx, int my) {
        if (this.i < 0) {
            this.refresh();
            this.i = 60;
        } else {
            --this.i;
        }
        super.tick(mx, my);
    }
}

