/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.EyeClient;
import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.elements.DeviceButton;
import com.podloot.eyemod.gui.util.Photos;
import com.podloot.eyemod.gui.util.Time;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeSlider;
import com.podloot.eyemod.lib.gui.widgets.EyeToggle;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class AppCamera
extends App {
    CameraType per = CameraType.FIRST_PERSON;
    int fov = 70;
    int panelColor = -825307442;
    int takePhoto = 0;
    EyeSlider zoom;

    public AppCamera() {
        super(new ResourceLocation("eyemod", "textures/gui/apps/appcamera.png"), -6710887, "Eye");
    }

    @Override
    public boolean load() {
        this.device.hidePanel(true, false);
        this.per = Minecraft.m_91087_().f_91066_.m_92176_();
        this.fov = (Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_();
        DeviceButton take = new DeviceButton(24, 24, EyeLib.PHOTO_TAKE);
        take.setAction(() -> {
            this.takePhoto = 5;
        });
        this.add(take, this.getWidth() / 2 - 12, this.getHeight() - 28);
        DeviceButton normal = new DeviceButton(16, 16, EyeLib.PHOTO_NORMAL);
        normal.setAction(() -> Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON));
        this.add(normal, 4, this.getHeight() - 24);
        DeviceButton selfie = new DeviceButton(16, 16, EyeLib.PHOTO_SELFIE);
        selfie.setAction(() -> Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_FRONT));
        this.add(selfie, 24, this.getHeight() - 24);
        DeviceButton person = new DeviceButton(16, 16, EyeLib.PHOTO_PERSON);
        person.setAction(() -> Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK));
        this.add(person, 44, this.getHeight() - 24);
        this.zoom = new EyeSlider(this.getWidth() / 2 - 18, 12, 0, 40);
        this.zoom.setState(21);
        this.add(this.zoom, this.getWidth() / 2 + 16, this.getHeight() - 22);
        return true;
    }

    @Override
    public void tick(int mx, int my) {
        if (this.zoom != null) {
            Minecraft.m_91087_().f_91066_.m_231837_().m_231514_((Object)(this.zoom.getValue() * 2 + 30));
        }
        if (this.takePhoto > 0) {
            switch (this.takePhoto) {
                case 3: {
                    Minecraft.m_91087_().f_91066_.f_92062_ = true;
                    this.device.hidePanel(true, true);
                    this.hide(true);
                    break;
                }
                case 2: {
                    Object save = "Photo_" + Time.getTime();
                    save = ((String)save).replace(":", "_");
                    boolean saved = false;
                    saved = this.device.settings.getBool("camera_res") ? Photos.takeShot((String)save) : Photos.takeShotLow((String)save);
                    if (saved) {
                        this.device.addNotification(EyeClient.APPPHOTOS.getId(), "New photo: " + (String)save);
                        break;
                    }
                    this.device.addNotification(EyeClient.APPPHOTOS.getId(), "Failed to save: " + (String)save);
                    break;
                }
                case 1: {
                    Minecraft.m_91087_().f_91066_.f_92062_ = false;
                    this.device.hidePanel(true, false);
                    this.hide(false);
                }
            }
            --this.takePhoto;
        }
        super.tick(mx, my);
    }

    @Override
    public List<EyeWidget> getSettings(int width) {
        ArrayList<EyeWidget> settings = new ArrayList<EyeWidget>();
        EyeToggle res = new EyeToggle(20, 12);
        res.setText(new Line("text.eyemod.camera_resolution"));
        res.setState(this.device.settings.getBool("camera_res"));
        res.setAction(() -> this.device.settings.setBool("camera_res", res.getToggle()));
        settings.add(res);
        return settings;
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        EyeDraw.rect(matrices, x, y + this.getHeight() - 32, this.getWidth(), 32, 0x44444444);
        super.draw(matrices, x, y);
    }

    @Override
    public void close() {
        Minecraft.m_91087_().f_91066_.m_92157_(this.per);
        Minecraft.m_91087_().f_91066_.m_231837_().m_231514_((Object)this.fov);
        this.device.hidePanel(false, false);
        super.close();
    }
}

