/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.panels.EyeBoxPanel;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Space;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeList;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;

public abstract class AppTextList
extends App {
    EyeList list;
    ListTag text;
    Space space;
    public EyeButton open;
    public EyeButton close;

    public AppTextList(ResourceLocation icon, int color, String creator) {
        super(icon, color, creator);
    }

    public void setList(Space space, ListTag text) {
        this.space = space;
        this.text = text;
    }

    @Override
    public boolean load() {
        this.loadList();
        return true;
    }

    public void loadList() {
        if (this.list != null) {
            this.list.clearList();
            this.remove(this.list);
        }
        this.list = new EyeList(this.space.width, this.space.height, EyeWidget.Axis.VERTICAL);
        for (int i = this.text.size() - 1; i >= 0; --i) {
            if (this.text.m_7264_() == Naming.Type.COMPOUND.type) {
                this.list.add(this.getPanel(i, this.text.m_128728_(i)));
                continue;
            }
            this.list.add(this.getPanel(i, this.asNbt(this.text.m_128778_(i))));
        }
        this.add(this.list, this.space.x, this.space.y);
    }

    public CompoundTag asNbt(String info) {
        CompoundTag in = new CompoundTag();
        String[] infos = info.split("~");
        for (int i = 0; i < infos.length; ++i) {
            in.m_128359_("" + i, infos[i]);
        }
        return in;
    }

    public EyeWidget getPanel(int index, CompoundTag info) {
        EyeBoxPanel box = new EyeBoxPanel(this.list.getWidth(), 16, EyeWidget.Axis.VERTICAL, 0);
        box.setBack(this.appColor);
        box.add(-1, this.getMain(box, index, info));
        return box;
    }

    public EyeButton getFold(EyeBoxPanel box, EyeWidget exp, Space space, Line open, int color_open, Line close, int color_close) {
        EyeButton fold = new EyeButton(space.width, space.height, open);
        fold.setColor(color_open);
        fold.setAction(() -> {
            if (fold.getText().equals(open)) {
                box.add(-1, exp);
                fold.setText(close);
                fold.setColor(color_close);
            } else {
                box.remove(exp);
                fold.setText(open);
                fold.setColor(color_open);
            }
            box.setItems();
            this.list.updateItems();
        });
        return fold;
    }

    public abstract EyeWidget getMain(EyeBoxPanel var1, int var2, CompoundTag var3);

    public abstract EyeWidget getExpendable(EyeBoxPanel var1, int var2, CompoundTag var3);
}

