/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.events.EyeDeviceEvent;
import com.podloot.eyemod.events.EyeEvents;
import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.gui.util.Time;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Image;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeIcon;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeList;
import com.podloot.eyemod.lib.gui.widgets.EyePlane;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.HashMap;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AppStart
extends App {
    public boolean locked = true;
    HashMap<String, Image> weather = new HashMap();
    EyeList notifications;

    public AppStart() {
        super(new ResourceLocation("eyemod", "textures/gui/appdefault.png"), -3223858, "Eye");
        this.isStock = true;
        this.weather.put("text.eyemod.weather_sunny", EyeLib.SUNNY);
        this.weather.put("text.eyemod.weather_raining", EyeLib.RAIN);
        this.weather.put("text.eyemod.weather_snowing", EyeLib.SNOW);
        this.weather.put("text.eyemod.weather_thunder", EyeLib.THUNDER);
    }

    @Override
    public boolean load() {
        this.notifications = new EyeList(this.getWidth() - 10, 70, EyeWidget.Axis.VERTICAL);
        this.notifications.hideScrollbar(true);
        ListTag no = this.device.data.getList("notifications", Naming.Type.STRING);
        for (int i = no.size() - 1; i >= 0; --i) {
            String[] in;
            String s = no.m_128778_(i);
            if (!s.contains("~") || (in = s.split("~")).length <= 1) continue;
            App a = this.device.getApp(new ResourceLocation(in[0]));
            EyePanel np = this.getNote(a, in[1]);
            if (a == null || np == null) continue;
            this.notifications.add(np);
        }
        this.add(this.notifications, 10, 84);
        this.locked = this.device.isLocked();
        EyeIcon lock = new EyeIcon(24, 24, this.locked ? EyeLib.LOCKED : EyeLib.UNLOCKED);
        this.add(lock, this.getWidth() / 2 - 12, this.getHeight() - 28);
        EyePanel weath = new EyePanel(64, 24);
        String wn = this.device.getWeather();
        if (this.weather.containsKey(wn)) {
            EyeIcon w = new EyeIcon(24, 24, this.weather.get(wn));
            weath.add(w, 0, 0);
        }
        EyeLabel wl = new EyeLabel(42, 16, new Line(wn).setStyle(true, false));
        wl.setAlignment(1, 1);
        weath.add(wl, 26, 1);
        EyeLabel temp = new EyeLabel(42, 16, new Line("text.eyemod.weather_degrees").setStyle(false, true));
        temp.setAlignment(1, 1);
        temp.setVariable("" + this.device.getTemp());
        weath.add(temp, 26, 11);
        this.add(weath, this.getWidth() / 2 - 44, 54);
        return true;
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        EyeDraw.text(matrices, new Line(Time.getTime()).setScale(4.0f), x + this.getWidth() / 2, y + 36);
        super.draw(matrices, x, y);
    }

    public EyePanel getNote(App app, String msg) {
        EyeWidget a = app.getNotification(msg, this.notifications.getWidth() - 28);
        EyePanel n = new EyePanel(this.notifications.getWidth() - 10, a.getHeight());
        EyePlane back = new EyePlane(16, 16, app.getAppColor());
        EyeIcon icon = new EyeIcon(16, 16, app.appIcon);
        n.add(back, 0, a.getHeight() / 2 - 8);
        n.add(icon, 0, a.getHeight() / 2 - 8);
        n.add(a, 18, 0);
        return n;
    }

    @Override
    public void onHome() {
        if (!this.locked) {
            MinecraftForge.EVENT_BUS.post((Event)new EyeDeviceEvent(EyeEvents.EventSide.CLIENT, (Player)this.device.getUser(), this.device.getItem(), EyeEvents.DeviceAction.Login));
            super.onHome();
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new EyeDeviceEvent(EyeEvents.EventSide.CLIENT, (Player)this.device.getUser(), this.device.getItem(), EyeEvents.DeviceAction.Login_fail));
        }
    }
}

