/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps;

import com.podloot.eyemod.gui.apps.App;
import com.podloot.eyemod.gui.elements.AppButton;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class AppHome
extends App {
    int page = 0;

    public AppHome(int page) {
        super(new ResourceLocation("eyemod", "textures/gui/appdefault.png"), -3223858, "Eye");
        this.isStock = true;
        this.page = page;
    }

    @Override
    public boolean load() {
        this.openPage(this.page);
        return false;
    }

    public void openPage(int page) {
        List<App> apps = this.device.getInstalledApps();
        if (apps.size() < page * 12 + 1) {
            return;
        }
        this.device.setLastPage(page);
        this.clear();
        int sx = this.getWidth() / 3;
        int sy = (this.getHeight() - 4) / 4;
        this.page = page;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 4; ++y) {
                int id = x + y * 3 + page * 12;
                if (id >= apps.size()) continue;
                App app = apps.get(id);
                AppButton app_button = new AppButton(app);
                app_button.setAction(() -> this.device.openApp(app));
                this.add(app_button, x * sx + (sx / 2 - 16), y * sy + (sy / 2 - 16));
            }
        }
    }

    @Override
    public void onHome() {
        if (this.page != 0) {
            this.openPage(0);
        } else if (this.device != null) {
            this.device.closeDevice();
        }
    }

    @Override
    public void onLeft() {
        if (this.page > 0) {
            this.openPage(this.page - 1);
        }
    }

    @Override
    public void onRight() {
        this.openPage(this.page + 1);
    }
}

