/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui.apps;

import com.podloot.eyemod.events.EyeAppEvent;
import com.podloot.eyemod.events.EyeEvents;
import com.podloot.eyemod.gui.GuiDevice;
import com.podloot.eyemod.gui.panes.Pane;
import com.podloot.eyemod.lib.gui.panels.EyePanel;
import com.podloot.eyemod.lib.gui.util.Image;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class App
extends EyePanel {
    protected GuiDevice device;
    private ResourceLocation id;
    private String creator;
    int price = 0;
    int access = 0;
    public Image appIcon;
    public int appColor = -3223858;
    boolean isStock = false;
    boolean useNet = false;
    boolean useLocation = false;
    boolean isOP = false;
    boolean hasData = false;
    List<Pane> panes = new ArrayList<Pane>();
    private boolean loaded = false;
    private int refresh = -1;
    public boolean reset = true;

    public App(ResourceLocation icon, int color, String creator) {
        super(0, 0);
        this.appIcon = new Image(icon, 32, 32);
        this.appColor = color;
        this.creator = creator;
    }

    public App setDefault(int price, int access) {
        this.price = price;
        this.access = access;
        return this;
    }

    public App setStock() {
        this.isStock = true;
        return this;
    }

    public App setNet() {
        this.useNet = true;
        return this;
    }

    public App setLocation() {
        this.useLocation = true;
        return this;
    }

    public App useData() {
        this.hasData = true;
        return this;
    }

    public App setOp() {
        this.isOP = true;
        return this;
    }

    public void set(GuiDevice device, int price, int access) {
        this.device = device;
        this.price = price;
        this.access = access;
        this.setup();
    }

    public void setup() {
    }

    public void open() {
        this.closePanes();
        if (this.device == null) {
            return;
        }
        if (this.reset) {
            this.clear();
        }
        if (!this.loaded) {
            this.loaded = this.load();
        }
    }

    public abstract boolean load();

    @Override
    public void clear() {
        this.closePanes();
        this.loaded = false;
        super.clear();
    }

    @Override
    public void close() {
        super.close();
    }

    public void onRefresh() {
        this.clear();
        this.load();
    }

    public void refresh() {
        this.refresh = 8;
    }

    public void onHomeGeneral() {
        if (!this.panes.isEmpty()) {
            this.closePane(this.panes.get(this.panes.size() - 1));
        } else {
            this.onHome();
        }
    }

    public void onHome() {
        MinecraftForge.EVENT_BUS.post((Event)new EyeAppEvent(EyeEvents.EventSide.CLIENT, (Player)this.device.getUser(), this.device.getItem(), this, EyeEvents.AppAction.Close));
        this.device.openHome();
    }

    public void onLeft() {
    }

    public void onRight() {
    }

    @Override
    public void tick(int mx, int my) {
        if (this.refresh > 0) {
            if (this.refresh == 1) {
                this.onRefresh();
            }
            --this.refresh;
        }
        super.tick(mx, my);
    }

    public List<EyeWidget> getSettings(int width) {
        return null;
    }

    public void onClearData() {
    }

    public EyeWidget getNotification(String message, int width) {
        EyeButton msg = new EyeButton(width, 16);
        msg.setText(new Line(message));
        msg.setColor(this.getAppColor());
        msg.setAction(() -> {
            if (this.device != null && !this.device.isLocked()) {
                this.device.openApp(this);
            }
        });
        return msg;
    }

    public void openPane(Pane pane) {
        pane.setBack(-12303292);
        this.panes.add(pane);
        this.add(pane, this.getWidth() / 2 - pane.getWidth() / 2, this.getHeight() / 2 - pane.getHeight() / 2);
    }

    public void closePane(Pane pane) {
        if (this.panes.contains(pane)) {
            this.panes.remove(pane);
            this.remove(pane);
        }
    }

    public void closePanes() {
        ArrayList<Pane> remove = new ArrayList<Pane>();
        for (Pane p : this.panes) {
            p.close();
            this.remove(p);
            remove.add(p);
        }
        this.panes.removeAll(remove);
    }

    public int getPrice() {
        return this.price;
    }

    public int getAccess() {
        return this.access;
    }

    public boolean isStock() {
        return this.isStock;
    }

    public boolean isOP() {
        return this.isOP;
    }

    public boolean hasData() {
        return this.hasData;
    }

    public boolean useNet() {
        return this.useNet;
    }

    public boolean useLocation() {
        return this.useLocation;
    }

    public Line getName() {
        return new Line("app." + this.getId().m_135827_() + "." + this.getId().m_135815_() + ".name");
    }

    public Line getDescription() {
        return new Line("app." + this.getId().m_135827_() + "." + this.getId().m_135815_() + ".desc");
    }

    public int getAppColor() {
        return this.appColor;
    }

    public String getCreator() {
        return this.creator;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public GuiDevice getDevice() {
        return this.device;
    }
}

