/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.blocks.entities.RouterEntity;
import com.podloot.eyemod.events.EyeConnectEvent;
import com.podloot.eyemod.events.EyeEvents;
import com.podloot.eyemod.gui.util.NbtManager;
import com.podloot.eyemod.lib.gui.EyeScreen;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Pos;
import com.podloot.eyemod.lib.gui.widgets.EyeButton;
import com.podloot.eyemod.lib.gui.widgets.EyeLabel;
import com.podloot.eyemod.lib.gui.widgets.EyeTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GuiRouter
extends EyeScreen {
    NbtManager data;
    Pos router;
    boolean canOpen;

    public GuiRouter(InteractionHand hand, Pos router, boolean canOpen) {
        super("Router", 160, canOpen ? 38 : 56);
        this.data = new NbtManager(hand);
        this.router = router;
        this.canOpen = canOpen;
        this.load();
    }

    public void load() {
        this.base.setBack(-12303292);
        EyeTextField pass = new EyeTextField(this.base.getWidth() - 8, 16);
        pass.setLimit(16);
        pass.setText(new Line("text.eyemod.settings_password"));
        EyeLabel enter = new EyeLabel(this.base.getWidth(), 16, new Line(this.canOpen ? "text.eyemod.net_public" : "text.eyemod.net_enter"));
        this.base.add(enter, 0, 2);
        if (!this.canOpen) {
            this.base.add(pass, 4, this.base.getHeight() - 38);
        }
        EyeButton cancel = new EyeButton(this.base.getWidth() / 2 - 6, 16, new Line("text.eyemod.cancel"));
        cancel.setAction(() -> Minecraft.m_91087_().m_91152_(null));
        cancel.setColor(-292985);
        this.base.add(cancel, 4, this.base.getHeight() - 20);
        EyeButton connect = new EyeButton(this.base.getWidth() / 2 - 6, 16, new Line("text.eyemod.net_connect"));
        connect.setAction(() -> {
            if ((this.canOpen || pass.getInput().equals(this.getRouterPassword())) && this.router != null) {
                MinecraftForge.EVENT_BUS.post((Event)new EyeConnectEvent(EyeEvents.EventSide.CLIENT, (Player)this.getUser(), null, this.router.getPos(), EyeEvents.ConnectAction.Connected));
                this.data.setPos("router", this.router);
                this.data.setString("net", this.getRouterPassword());
                Minecraft.m_91087_().m_91152_(null);
                Minecraft.m_91087_().f_91074_.m_5661_((Component)new Line("text.eyemod.block_router_connect").asText(), true);
                Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11897_, 1.0f, 1.0f);
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new EyeConnectEvent(EyeEvents.EventSide.CLIENT, (Player)this.getUser(), null, this.router.getPos(), EyeEvents.ConnectAction.FailedToConnect));
            }
        });
        this.base.add(connect, 82, this.base.getHeight() - 20);
    }

    public String getRouterPassword() {
        if (this.router != null && this.getUser().f_19853_.m_7702_(this.router.getPos()) instanceof RouterEntity) {
            return ((RouterEntity)this.getUser().f_19853_.m_7702_((BlockPos)this.router.getPos())).password;
        }
        return "|";
    }

    public LocalPlayer getUser() {
        return Minecraft.m_91087_().f_91074_;
    }

    public ResourceLocation getWorldID() {
        return this.getUser().m_9236_().m_46472_().m_135782_();
    }

    @Override
    public void paint(PoseStack matrices) {
    }

    @Override
    public void update(int mouseX, int mouseY) {
        this.data.update();
    }
}

